/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.api.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.Truffle;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.TruffleOptions;
import kasuga.lib.vendor_modules.org.graalvm.nativeimage.ImageInfo;

public abstract class TruffleLocator {
    private static TruffleLocator nativeImageLocator;
    private static final AtomicBoolean NATIVE_IMAGE_LOCATOR_INITIALIZED;

    public static List<ClassLoader> loaders() {
        TruffleLocator locator = Truffle.getRuntime().getCapability(TruffleLocator.class);
        if (locator != null) {
            ArrayList<ClassLoader> found = new ArrayList<ClassLoader>();
            Response response = new Response(found);
            locator.locate(response);
            if (found.isEmpty()) {
                return null;
            }
            return found;
        }
        return null;
    }

    static void initializeNativeImageTruffleLocator() {
        assert (TruffleOptions.AOT) : "Only supported in AOT mode.";
        if (nativeImageLocator != null && (ImageInfo.inImageBuildtimeCode() || NATIVE_IMAGE_LOCATOR_INITIALIZED.compareAndSet(false, true))) {
            nativeImageLocator.locate(new Response(new ArrayList<ClassLoader>()));
        }
    }

    protected abstract void locate(Response var1);

    private static void initializeNativeImageState() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageLocator = Truffle.getRuntime().getCapability(TruffleLocator.class);
    }

    private static void resetNativeImageState() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageLocator = null;
    }

    static {
        NATIVE_IMAGE_LOCATOR_INITIALIZED = new AtomicBoolean();
    }

    public static final class Response {
        private final List<ClassLoader> loaders;

        Response(List<ClassLoader> loaders) {
            this.loaders = loaders;
        }

        public void registerClassLoader(ClassLoader languageLoader) {
            this.loaders.add(languageLoader);
        }
    }
}

