/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.api.interop;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.StopIterationException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.TruffleObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedMessageException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.CachedLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportMessage;

@ExportLibrary(value=InteropLibrary.class)
final class ArrayIterator
implements TruffleObject {
    final Object array;
    private long currentItemIndex;

    ArrayIterator(Object array) {
        this.array = array;
        assert (InteropLibrary.getUncached().hasArrayElements(array)) : "Array must have array elements.";
    }

    @ExportMessage
    boolean isIterator() {
        return true;
    }

    @ExportMessage
    boolean hasIteratorNextElement(@CachedLibrary(value="this.array") InteropLibrary arrays) {
        try {
            return this.currentItemIndex < arrays.getArraySize(this.array);
        }
        catch (UnsupportedMessageException ume) {
            throw CompilerDirectives.shouldNotReachHere(ume);
        }
    }

    @ExportMessage
    Object getIteratorNextElement(@CachedLibrary(value="this.array") InteropLibrary arrays) throws UnsupportedMessageException, StopIterationException {
        try {
            long size = arrays.getArraySize(this.array);
            if (this.currentItemIndex >= size) {
                throw StopIterationException.create();
            }
            Object res = arrays.readArrayElement(this.array, this.currentItemIndex);
            ++this.currentItemIndex;
            return res;
        }
        catch (UnsupportedMessageException ume) {
            throw CompilerDirectives.shouldNotReachHere(ume);
        }
        catch (InvalidArrayIndexException iaie) {
            throw UnsupportedMessageException.create();
        }
    }
}

