/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.helper;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.Assumption;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.object.Shape;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.RegExpPrototypeBuiltins;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.builtins.helper.IsPristineObjectNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRealm;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Symbol;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSClass;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSProxy;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSRegExp;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public abstract class IsPristineObjectNode
extends JavaScriptBaseNode {
    private final JSClass jsClass;
    private final Shape initialPrototypeShape;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Object[] propertyKeys;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Assumption[] propertyFinalAssumptions;
    @Node.Child
    private GetPrototypeNode getPrototypeNode = GetPrototypeNode.create();

    IsPristineObjectNode(JSClass jsClass, Shape initialPrototypeShape, Object ... propertyKeys) {
        assert (jsClass != JSProxy.INSTANCE) : "not supported because getting the prototype of proxy objects can have side effects";
        this.jsClass = jsClass;
        this.initialPrototypeShape = initialPrototypeShape;
        this.propertyKeys = propertyKeys;
        this.propertyFinalAssumptions = new Assumption[propertyKeys.length];
        for (int i = 0; i < propertyKeys.length; ++i) {
            this.propertyFinalAssumptions[i] = initialPrototypeShape.getProperty(propertyKeys[i]).getLocation().getFinalAssumption();
        }
    }

    public static IsPristineObjectNode create(JSClass jsClass, Shape initialPrototypeShape, Object ... propertyKeys) {
        return IsPristineObjectNodeGen.create(jsClass, initialPrototypeShape, propertyKeys);
    }

    public static IsPristineObjectNode createRegExpExecAndMatch(JSContext context) {
        assert (context.getEcmaScriptVersion() >= 6);
        assert (Strings.equals(Strings.EXEC, (TruffleString)RegExpPrototypeBuiltins.RegExpPrototype.exec.getKey()));
        return IsPristineObjectNode.create(JSRegExp.INSTANCE, JSRealm.get(null).getInitialRegExpPrototypeShape(), Symbol.SYMBOL_MATCH, Strings.EXEC, JSRegExp.FLAGS, JSRegExp.GLOBAL, JSRegExp.UNICODE, JSRegExp.STICKY);
    }

    public abstract boolean execute(JSDynamicObject var1);

    @Specialization(guards={"cachedShape.check(object)"}, assumptions={"getPropertyFinalAssumptions()"})
    boolean doCached(JSDynamicObject object, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="isInstanceAndDoesNotOverwriteProps(cachedShape)") boolean isInstanceAndDoesNotOverwriteProps) {
        return isInstanceAndDoesNotOverwriteProps && this.prototypeShapeUnchanged(object);
    }

    @Specialization(assumptions={"getPropertyFinalAssumptions()"}, replaces={"doCached"})
    boolean doDynamic(JSDynamicObject object) {
        return this.isInstanceAndDoesNotOverwriteProps(object.getShape()) && this.prototypeShapeUnchanged(object);
    }

    @Specialization
    boolean doAssumptionsInvalid(JSDynamicObject object) {
        return false;
    }

    Assumption[] getPropertyFinalAssumptions() {
        return this.propertyFinalAssumptions;
    }

    private boolean prototypeShapeUnchanged(JSDynamicObject object) {
        return this.getPrototypeNode.execute(object).getShape() == this.initialPrototypeShape;
    }

    boolean isInstanceAndDoesNotOverwriteProps(Shape objectShape) {
        if (objectShape.getDynamicType() != this.jsClass) {
            return false;
        }
        for (Object key : this.propertyKeys) {
            if (!objectShape.hasProperty(key)) continue;
            return false;
        }
        return true;
    }
}

