/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary;

import java.util.Objects;
import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.InstrumentableNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.NodeInfo;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.ConditionProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.JSConstantNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary.JSBitwiseOrConstantNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary.JSBitwiseOrNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary.JSBitwiseOrNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.BigInt;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRuntime;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.SafeInteger;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;

@NodeInfo(shortName="|")
public abstract class JSBitwiseOrConstantNode
extends JSUnaryNode {
    protected final int rightIntValue;
    protected final BigInt rightBigIntValue;
    protected final boolean isInt;

    protected JSBitwiseOrConstantNode(JavaScriptNode left, Object rightValue) {
        super(left);
        if (rightValue instanceof BigInt) {
            this.isInt = false;
            this.rightBigIntValue = (BigInt)rightValue;
            this.rightIntValue = 0;
        } else {
            this.isInt = true;
            this.rightBigIntValue = null;
            this.rightIntValue = (Integer)rightValue;
        }
    }

    public static JavaScriptNode create(JavaScriptNode left, Object rightValue) {
        return JSBitwiseOrConstantNodeGen.create(left, rightValue);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.BinaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.BinaryOperationTag.class)) {
            JSConstantNode constantNode = JSConstantNode.create(this.isInt ? Integer.valueOf(this.rightIntValue) : this.rightBigIntValue);
            JSBitwiseOrNode node = JSBitwiseOrNodeGen.create(JSBitwiseOrConstantNode.cloneUninitialized(this.getOperand(), materializedTags), constantNode);
            JSBitwiseOrConstantNode.transferSourceSectionAddExpressionTag(this, constantNode);
            JSBitwiseOrConstantNode.transferSourceSectionAndTags(this, node);
            return node;
        }
        return this;
    }

    public abstract Object executeObject(Object var1);

    @Specialization(guards={"isInt"})
    protected int doInteger(int a) {
        return a | this.rightIntValue;
    }

    @Specialization(guards={"isInt"})
    protected int doSafeInteger(SafeInteger a) {
        return this.doInteger(a.intValue());
    }

    @Specialization(guards={"isInt"})
    protected int doDouble(double a, @Cached(value="create()") JSToInt32Node leftInt32) {
        return this.doInteger(leftInt32.executeInt(a));
    }

    @Specialization(guards={"!isInt"})
    protected void doIntegerThrows(int a) {
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @Specialization(guards={"!isInt"})
    protected void doDoubleThrows(double a) {
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @Specialization(guards={"isInt"})
    protected void doBigIntThrows(BigInt a) {
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @Specialization(guards={"!isInt"})
    protected BigInt doBigInt(BigInt a) {
        return a.or(a);
    }

    @Specialization
    protected Object doOverloaded(JSOverloadedOperatorsObject a, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a, this.isInt ? Integer.valueOf(this.rightIntValue) : this.rightBigIntValue);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.SYMBOL_PIPE;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "isInt"}, replaces={"doInteger", "doSafeInteger", "doDouble", "doBigIntThrows"})
    protected Object doGenericIntCase(Object a, @Cached(value="create()") JSToNumericNode toNumeric, @Cached(value="createBinaryProfile()") ConditionProfile profileIsBigInt, @Cached(value="makeCopy()") JavaScriptNode innerOrNode) {
        Object numericA = toNumeric.execute(a);
        if (profileIsBigInt.profile(JSRuntime.isBigInt(numericA))) {
            throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
        }
        return ((JSBitwiseOrConstantNode)innerOrNode).executeObject(numericA);
    }

    protected JSBitwiseOrConstantNode makeCopy() {
        return (JSBitwiseOrConstantNode)this.copyUninitialized(null);
    }

    protected final boolean isInt() {
        return this.isInt;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!isInt()"}, replaces={"doIntegerThrows", "doDoubleThrows", "doBigInt"})
    protected BigInt doGenericBigIntCase(Object a, @Cached(value="create()") JSToNumericNode toNumeric, @Cached(value="createBinaryProfile()") ConditionProfile profileIsBigInt) {
        Object numericA = toNumeric.execute(a);
        if (profileIsBigInt.profile(JSRuntime.isBigInt(numericA))) {
            return this.doBigInt((BigInt)numericA);
        }
        throw Errors.createTypeErrorCannotMixBigIntWithOtherTypes(this);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSBitwiseOrConstantNodeGen.create(JSBitwiseOrConstantNode.cloneUninitialized(this.getOperand(), materializedTags), (Object)(this.isInt ? Integer.valueOf(this.rightIntValue) : this.rightBigIntValue));
    }

    @Override
    public String expressionToString() {
        if (this.getOperand() != null) {
            return "(" + Objects.toString(this.getOperand().expressionToString(), "(intermediate value)") + " | " + (this.isInt ? Integer.valueOf(this.rightIntValue) : this.rightBigIntValue) + ")";
        }
        return null;
    }
}

