/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control;

import java.util.ArrayDeque;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.VirtualFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control.AsyncGeneratorResumeNextNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSArguments;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSFunction;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;

public class AsyncGeneratorResolveNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getAsyncGeneratorQueueNode;
    @Node.Child
    private CreateIterResultObjectNode createIterResultObjectNode;
    @Node.Child
    private JSFunctionCallNode callResolveNode;
    @Node.Child
    private AsyncGeneratorResumeNextNode asyncGeneratorResumeNextNode;

    protected AsyncGeneratorResolveNode(JSContext context) {
        this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
        this.getAsyncGeneratorQueueNode = PropertyGetNode.createGetHidden(JSFunction.ASYNC_GENERATOR_QUEUE_ID, context);
        this.callResolveNode = JSFunctionCallNode.createCall();
    }

    public static AsyncGeneratorResolveNode create(JSContext context) {
        return new AsyncGeneratorResolveNode(context);
    }

    public Object execute(VirtualFrame frame, JSDynamicObject generator, Object value, boolean done) {
        this.performResolve(frame, generator, value, done);
        if (this.asyncGeneratorResumeNextNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.asyncGeneratorResumeNextNode = this.insert(AsyncGeneratorResumeNextNode.create(this.getContext()));
        }
        this.asyncGeneratorResumeNextNode.execute(frame, generator);
        return Undefined.instance;
    }

    void performResolve(VirtualFrame frame, JSDynamicObject generator, Object value, boolean done) {
        ArrayDeque queue = (ArrayDeque)this.getAsyncGeneratorQueueNode.getValue(generator);
        assert (!queue.isEmpty());
        AsyncGeneratorRequest next = (AsyncGeneratorRequest)queue.pollFirst();
        PromiseCapabilityRecord promiseCapability = next.getPromiseCapability();
        JSDynamicObject iteratorResult = this.createIterResultObjectNode.execute(frame, value, done);
        Object resolve = promiseCapability.getResolve();
        this.callResolveNode.executeCall(JSArguments.createOneArg(Undefined.instance, resolve, iteratorResult));
    }

    private JSContext getContext() {
        return this.getAsyncGeneratorQueueNode.getContext();
    }
}

