/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control;

import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.VirtualFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.BranchProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.GetIteratorBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.GetMethodNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.IteratorCompleteNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.IteratorNextNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.IteratorValueNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control.AbstractYieldNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control.ResumableNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control.ReturnNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control.YieldResultNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSArguments;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRuntime;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Completion;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.IteratorRecord;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;

public class YieldStarNode
extends AbstractYieldNode
implements ResumableNode.WithObjectState {
    @Node.Child
    private GetIteratorBaseNode getIteratorNode;
    @Node.Child
    private IteratorNextNode iteratorNextNode;
    @Node.Child
    private IteratorCompleteNode iteratorCompleteNode;
    @Node.Child
    private IteratorValueNode iteratorValueNode;
    @Node.Child
    private GetMethodNode getThrowMethodNode;
    @Node.Child
    private GetMethodNode getReturnMethodNode;
    @Node.Child
    private JSFunctionCallNode callThrowNode;
    @Node.Child
    private JSFunctionCallNode callReturnNode;
    @Node.Child
    private IteratorCloseNode iteratorCloseNode;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected YieldStarNode(JSContext context, int stateSlot, JavaScriptNode expression, JavaScriptNode yieldValue, ReturnNode returnNode, YieldResultNode yieldResultNode) {
        super(context, stateSlot, expression, yieldValue, returnNode, yieldResultNode);
        this.getIteratorNode = GetIteratorBaseNode.create();
        this.iteratorNextNode = IteratorNextNode.create();
        this.iteratorCompleteNode = IteratorCompleteNode.create(context);
        this.iteratorValueNode = IteratorValueNode.create();
        this.getThrowMethodNode = GetMethodNode.create(context, Strings.THROW);
        this.getReturnMethodNode = GetMethodNode.create(context, Strings.RETURN);
        this.callThrowNode = JSFunctionCallNode.createCall();
        this.callReturnNode = JSFunctionCallNode.createCall();
        this.iteratorCloseNode = IteratorCloseNode.create(context);
    }

    private Object executeBegin(VirtualFrame frame) {
        JSDynamicObject received;
        IteratorRecord iteratorRecord = this.getIteratorNode.execute(this.expression.execute(frame));
        Object innerResult = this.iteratorNextNode.execute(iteratorRecord, received = Undefined.instance);
        if (this.iteratorCompleteNode.execute(innerResult)) {
            return this.iteratorValueNode.execute(innerResult);
        }
        return this.saveStateAndYield(frame, iteratorRecord, innerResult);
    }

    private Object saveStateAndYield(VirtualFrame frame, IteratorRecord iteratorRecord, Object innerResult) {
        this.setState(frame, this.stateSlot, iteratorRecord);
        return this.generatorYield(frame, innerResult);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object state = this.getState(frame, this.stateSlot);
        if (state == Undefined.instance) {
            return this.executeBegin(frame);
        }
        this.resetState(frame, this.stateSlot);
        IteratorRecord iteratorRecord = (IteratorRecord)state;
        Object received = this.yieldValue.execute(frame);
        if (!(received instanceof Completion)) {
            Object innerResult = this.iteratorNextNode.execute(iteratorRecord, received);
            if (this.iteratorCompleteNode.execute(innerResult)) {
                return this.iteratorValueNode.execute(innerResult);
            }
            return this.saveStateAndYield(frame, iteratorRecord, innerResult);
        }
        Completion completion = (Completion)received;
        received = completion.getValue();
        if (this.returnOrExceptionProfile.profile(completion.isThrow())) {
            return this.resumeThrow(frame, iteratorRecord, received);
        }
        assert (completion.isReturn());
        return this.resumeReturn(frame, iteratorRecord, received);
    }

    private Object resumeReturn(VirtualFrame frame, IteratorRecord iteratorRecord, Object received) {
        JSDynamicObject iterator = iteratorRecord.getIterator();
        Object returnMethod = this.getReturnMethodNode.executeWithTarget(iterator);
        if (returnMethod == Undefined.instance) {
            return this.returnValue(frame, received);
        }
        JSDynamicObject innerReturnResult = this.callReturnMethod(iterator, received, returnMethod);
        if (this.iteratorCompleteNode.execute(innerReturnResult)) {
            return this.returnValue(frame, this.iteratorValueNode.execute(innerReturnResult));
        }
        return this.saveStateAndYield(frame, iteratorRecord, innerReturnResult);
    }

    private Object resumeThrow(VirtualFrame frame, IteratorRecord iteratorRecord, Object received) {
        JSDynamicObject iterator = iteratorRecord.getIterator();
        Object throwMethod = this.getThrowMethodNode.executeWithTarget(iterator);
        if (throwMethod != Undefined.instance) {
            JSDynamicObject innerResult = this.callThrowMethod(iterator, received, throwMethod);
            if (this.iteratorCompleteNode.execute(innerResult)) {
                return this.iteratorValueNode.execute(innerResult);
            }
            return this.saveStateAndYield(frame, iteratorRecord, innerResult);
        }
        this.errorBranch.enter();
        this.iteratorCloseNode.executeVoid(iterator);
        throw Errors.createTypeErrorYieldStarThrowMethodMissing(this);
    }

    private JSDynamicObject callThrowMethod(JSDynamicObject iterator, Object received, Object throwMethod) {
        Object innerResult = this.callThrowNode.executeCall(JSArguments.createOneArg(iterator, throwMethod, received));
        if (!JSRuntime.isObject(innerResult)) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorIterResultNotAnObject(innerResult, this);
        }
        return (JSDynamicObject)innerResult;
    }

    private JSDynamicObject callReturnMethod(JSDynamicObject iterator, Object received, Object returnMethod) {
        Object innerResult = this.callReturnNode.executeCall(JSArguments.createOneArg(iterator, returnMethod, received));
        if (!JSRuntime.isObject(innerResult)) {
            this.errorBranch.enter();
            throw Errors.createTypeErrorIterResultNotAnObject(innerResult, this);
        }
        return (JSDynamicObject)innerResult;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new YieldStarNode(this.context, this.stateSlot, YieldStarNode.cloneUninitialized(this.expression, materializedTags), YieldStarNode.cloneUninitialized(this.yieldValue, materializedTags), YieldStarNode.cloneUninitialized(this.returnNode, materializedTags), this.generatorYieldNode.cloneUninitialized());
    }
}

