/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.temporal;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.ConditionProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.IsObjectNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToStringNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.temporal.ToTemporalInstantNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.BigInt;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalInstantNode
extends JavaScriptBaseNode {
    protected final JSContext ctx;

    protected ToTemporalInstantNode(JSContext context) {
        this.ctx = context;
    }

    public static ToTemporalInstantNode create(JSContext context) {
        return ToTemporalInstantNodeGen.create(context);
    }

    public abstract JSTemporalInstantObject execute(Object var1);

    @Specialization
    public JSTemporalInstantObject toTemporalDateTime(Object item, @Cached(value="create()") IsObjectNode isObjectNode, @Cached(value="create()") JSToStringNode toStringNode, @Cached(value="createBinaryProfile()") ConditionProfile isObjectProfile) {
        if (isObjectProfile.profile(isObjectNode.executeBoolean(item))) {
            if (TemporalUtil.isTemporalInstant(item)) {
                return (JSTemporalInstantObject)item;
            }
            if (TemporalUtil.isTemporalZonedDateTime(item)) {
                return JSTemporalInstant.create(this.ctx, this.getRealm(), ((JSTemporalZonedDateTimeObject)item).getNanoseconds());
            }
        }
        TruffleString string = toStringNode.executeString(item);
        BigInt epochNanoseconds = TemporalUtil.parseTemporalInstant(string);
        return JSTemporalInstant.create(this.ctx, this.getRealm(), epochNanoseconds);
    }
}

