/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.unary;

import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Fallback;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.unary.IsIdenticalBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.unary.IsIdenticalIntegerNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.BigInt;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRuntime;

public abstract class IsIdenticalIntegerNode
extends IsIdenticalBaseNode {
    private final int integer;

    protected IsIdenticalIntegerNode(JavaScriptNode operand, int integer, boolean leftConstant) {
        super(operand, leftConstant);
        this.integer = integer;
    }

    @Specialization
    protected boolean doInt(int a) {
        return a == this.integer;
    }

    @Specialization
    protected boolean doDouble(double a) {
        return a == (double)this.integer;
    }

    @Specialization
    protected boolean doBigInt(BigInt a) {
        return false;
    }

    @Specialization(guards={"isJavaNumber(a)"})
    protected boolean doJavaNumber(Object a) {
        double doubleValue = JSRuntime.toDouble(a);
        return doubleValue == (double)this.integer;
    }

    @Fallback
    protected boolean doOther(Object other) {
        return false;
    }

    public static IsIdenticalIntegerNode create(int integer, JavaScriptNode operand, boolean leftConstant) {
        return IsIdenticalIntegerNodeGen.create(operand, integer, leftConstant);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return IsIdenticalIntegerNode.create(this.integer, IsIdenticalIntegerNode.cloneUninitialized(this.getOperand(), materializedTags), this.leftConstant);
    }

    @Override
    protected Object getConstantValue() {
        return this.integer;
    }
}

