/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal;

import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedMessageException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportMessage;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.object.Shape;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.BigInt;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZoneObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal.TemporalCalendar;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.TemporalConstants;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.TemporalUtil;

@ExportLibrary(value=InteropLibrary.class)
public class JSTemporalZonedDateTimeObject
extends JSNonProxyObject
implements TemporalCalendar {
    private final BigInt nanoseconds;
    private final JSDynamicObject timeZone;
    private final JSDynamicObject calendar;

    protected JSTemporalZonedDateTimeObject(Shape shape, BigInt nanoseconds, JSDynamicObject timeZone, JSDynamicObject calendar) {
        super(shape);
        this.nanoseconds = nanoseconds;
        this.calendar = calendar;
        this.timeZone = timeZone;
    }

    public BigInt getNanoseconds() {
        return this.nanoseconds;
    }

    @Override
    public JSDynamicObject getCalendar() {
        return this.calendar;
    }

    public JSDynamicObject getTimeZone() {
        return this.timeZone;
    }

    @CompilerDirectives.TruffleBoundary
    private Instant toInstant() {
        BigInteger[] res = this.nanoseconds.bigIntegerValue().divideAndRemainder(TemporalUtil.BI_10_POW_9);
        return Instant.ofEpochSecond(res[0].longValue(), res[1].intValue());
    }

    @ExportMessage
    final boolean isTimeZone() {
        return this.getZoneIdIntl() != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    final ZoneId asTimeZone() throws UnsupportedMessageException {
        ZoneId tzObj = this.getZoneIdIntl();
        if (tzObj == null) {
            throw UnsupportedMessageException.create();
        }
        return tzObj;
    }

    @CompilerDirectives.TruffleBoundary
    private ZoneId getZoneIdIntl() {
        if (this.timeZone instanceof JSTemporalTimeZoneObject) {
            JSTemporalTimeZoneObject tzObj = (JSTemporalTimeZoneObject)this.timeZone;
            return tzObj.asTimeZone();
        }
        Object tzID = JSObject.get(this.timeZone, TemporalConstants.TIME_ZONE);
        if (tzID instanceof TruffleString) {
            String id = ((TruffleString)tzID).toJavaStringUncached();
            return ZoneId.of(id);
        }
        return null;
    }

    @ExportMessage
    final boolean isDate() {
        return this.isTimeZone();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    final LocalDate asDate() throws UnsupportedMessageException {
        LocalDate ld = LocalDate.ofInstant(this.toInstant(), this.asTimeZone());
        return ld;
    }

    @ExportMessage
    final boolean isTime() {
        return this.isTimeZone();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    final LocalTime asTime() throws UnsupportedMessageException {
        LocalTime lt = LocalTime.ofInstant(this.toInstant(), this.asTimeZone());
        return lt;
    }
}

