/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.interop;

import java.util.ArrayList;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.TruffleObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnknownIdentifierException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedMessageException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.CachedLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportMessage;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.object.DynamicObjectLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.interop.ExportValueNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Properties;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.interop.InteropList;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Dead;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSProperty;

@ExportLibrary(value=InteropLibrary.class)
public final class DynamicScopeWrapper
implements TruffleObject {
    final JSDynamicObject scope;

    public DynamicScopeWrapper(JSDynamicObject scope) {
        this.scope = scope;
    }

    boolean isConst(TruffleString name, DynamicObjectLibrary access) {
        return JSProperty.isConst(Properties.getProperty(access, this.scope, name));
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal, @CachedLibrary(value="this.scope") DynamicObjectLibrary access) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Object key : access.getKeyArray(this.scope)) {
            Object value;
            if (!Strings.isTString(key) || (value = Properties.getOrDefault(access, this.scope, key, null)) == null || value == Dead.instance()) continue;
            keys.add(Strings.toJavaString((TruffleString)key));
        }
        return InteropList.create(keys);
    }

    @ExportMessage
    boolean isMemberReadable(String name, @Cached @Cached.Shared(value="fromJavaStringNode") TruffleString.FromJavaStringNode fromJavaStringNode, @CachedLibrary(value="this.scope") DynamicObjectLibrary access) {
        TruffleString tsName = Strings.fromJavaString(fromJavaStringNode, name);
        return this.isMemberReadableIntl(tsName, access);
    }

    private boolean isMemberReadableIntl(TruffleString tsName, DynamicObjectLibrary access) {
        Object value = Properties.getOrDefault(access, this.scope, tsName, null);
        return value != null && value != Dead.instance();
    }

    @ExportMessage
    boolean isMemberModifiable(String name, @Cached @Cached.Shared(value="fromJavaStringNode") TruffleString.FromJavaStringNode fromJavaStringNode, @CachedLibrary(value="this.scope") DynamicObjectLibrary access) {
        TruffleString tsName = Strings.fromJavaString(fromJavaStringNode, name);
        return this.isMemberReadableIntl(tsName, access) && !this.isConst(tsName, access);
    }

    @ExportMessage
    boolean isMemberInsertable(String name) {
        return false;
    }

    @ExportMessage
    Object readMember(String name, @Cached @Cached.Shared(value="fromJavaStringNode") TruffleString.FromJavaStringNode fromJavaStringNode, @CachedLibrary(value="this.scope") DynamicObjectLibrary access, @Cached ExportValueNode exportValueNode) throws UnknownIdentifierException {
        TruffleString tsName = Strings.fromJavaString(fromJavaStringNode, name);
        Object value = Properties.getOrDefault(access, this.scope, tsName, null);
        if (value == null || value == Dead.instance()) {
            throw UnknownIdentifierException.create(name);
        }
        return exportValueNode.execute(value);
    }

    @ExportMessage
    void writeMember(String name, Object value, @Cached @Cached.Shared(value="fromJavaStringNode") TruffleString.FromJavaStringNode fromJavaStringNode, @CachedLibrary(value="this.scope") DynamicObjectLibrary access) throws UnsupportedMessageException, UnknownIdentifierException {
        TruffleString tsName = Strings.fromJavaString(fromJavaStringNode, name);
        Object curValue = Properties.getOrDefault(access, this.scope, tsName, null);
        if (curValue == null || curValue == Dead.instance()) {
            throw UnknownIdentifierException.create(name);
        }
        if (this.isConst(tsName, access)) {
            throw UnsupportedMessageException.create();
        }
        Properties.putIfPresent(access, this.scope, tsName, value);
    }
}

