/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.polyglot;

import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.Truffle;

final class ModuleUtils {
    ModuleUtils() {
    }

    static void exportTo(ClassLoader loader, String moduleName) {
        assert (loader == null != (moduleName == null)) : "exactly one of a class loader or module name is required when exporting Truffle";
        Module truffleModule = Truffle.class.getModule();
        Module clientModule = moduleName != null ? truffleModule.getLayer().findModule(moduleName).orElseThrow() : loader.getUnnamedModule();
        ModuleUtils.exportFromTo(truffleModule, clientModule);
    }

    private static void exportFromTo(Module truffleModule, Module clientModule) {
        if (truffleModule != clientModule) {
            Set<String> packages = truffleModule.getPackages();
            for (String pkg : packages) {
                boolean exported = truffleModule.isExported(pkg, clientModule);
                if (exported) continue;
                truffleModule.addExports(pkg, clientModule);
            }
        }
    }
}

