/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.objects;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerAsserts;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.ArityException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.InteropLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.TruffleObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnknownIdentifierException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedMessageException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.interop.UnsupportedTypeException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.CachedLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportLibrary;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.library.ExportMessage;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.commands.Command;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.commands.Params;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.objects.AbstractInspectorObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.objects.InspectorStateException;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.objects.JSONTruffleObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.objects.JavaTruffleArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.objects.Keys;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.objects.TruffleObject2JSON;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.objects.UndefinedProvider;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.server.ConnectionWatcher;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.server.InspectServerSession;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.server.JSONMessageListener;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.utils.json.JSONObject;

class Session
extends AbstractInspectorObject {
    private static final String METHOD_CONNECT = "connect";
    private static final String METHOD_DISCONNECT = "disconnect";
    private static final String METHOD_EVENT_NAMES = "eventNames";
    private static final String METHOD_EMIT = "emit";
    private static final String METHOD_ADD_LISTENER = "addListener";
    private static final String METHOD_ON = "on";
    private static final String METHOD_ONCE = "once";
    private static final String METHOD_OFF = "off";
    private static final String METHOD_PREPEND_LISTENER = "prependListener";
    private static final String METHOD_PREPEND_ONCE_LISTENER = "prependOnceListener";
    private static final String METHOD_REMOVE_LISTENER = "removeListener";
    private static final String METHOD_REMOVE_ALL_LISTENERS = "removeAllListeners";
    private static final String METHOD_LISTENERS = "listeners";
    private static final String METHOD_LISTENER_COUNT = "listenerCount";
    private static final String METHOD_POST = "post";
    private static final String[] METHOD_NAMES = new String[]{"connect", "disconnect", "eventNames", "emit", "addListener", "on", "once", "off", "prependListener", "prependOnceListener", "removeListener", "removeAllListeners", "listeners", "listenerCount", "post"};
    private static final TruffleObject KEYS = new Keys(METHOD_NAMES);
    private final AtomicLong cmdId = new AtomicLong(1L);
    private final Supplier<InspectorExecutionContext> contextSupplier;
    private final UndefinedProvider undefinedProvider;
    private InspectServerSession iss;
    private Listeners listeners;

    Session(Supplier<InspectorExecutionContext> contextSupplier, UndefinedProvider undefinedProvider) {
        this.contextSupplier = contextSupplier;
        this.undefinedProvider = undefinedProvider;
    }

    public static boolean isInstance(TruffleObject obj) {
        return obj instanceof Session;
    }

    @Override
    protected TruffleObject getMembers(boolean includeInternal) {
        return KEYS;
    }

    @Override
    protected boolean isField(String name) {
        return false;
    }

    @Override
    protected Object getFieldValueOrNull(String name) {
        return null;
    }

    @Override
    protected boolean isMethod(String name) {
        switch (name) {
            case "connect": 
            case "disconnect": 
            case "eventNames": 
            case "emit": 
            case "addListener": 
            case "on": 
            case "once": 
            case "off": 
            case "prependListener": 
            case "prependOnceListener": 
            case "removeListener": 
            case "removeAllListeners": 
            case "listeners": 
            case "listenerCount": 
            case "post": {
                return true;
            }
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected Object invokeMember(String name, Object[] arguments) throws ArityException, UnsupportedTypeException, UnknownIdentifierException, UnsupportedMessageException {
        switch (name) {
            case "connect": {
                return this.connect();
            }
            case "disconnect": {
                return this.disconnect();
            }
            case "eventNames": {
                return this.getListeners().getEventNames();
            }
            case "emit": {
                return this.emit(arguments);
            }
            case "addListener": {
                return this.addListener(arguments, false);
            }
            case "on": {
                return this.addListener(arguments, false);
            }
            case "once": {
                return this.addOnceListener(arguments, false);
            }
            case "off": {
                return this.removeListener(arguments);
            }
            case "prependListener": {
                return this.addListener(arguments, true);
            }
            case "prependOnceListener": {
                return this.addOnceListener(arguments, true);
            }
            case "removeListener": {
                return this.removeListener(arguments);
            }
            case "removeAllListeners": {
                return this.removeAllListeners(arguments);
            }
            case "listeners": {
                return this.listeners(arguments);
            }
            case "listenerCount": {
                return this.listenerCount(arguments);
            }
            case "post": {
                return this.post(arguments);
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw UnknownIdentifierException.create(name);
    }

    private Object connect() {
        if (this.iss != null) {
            throw new InspectorStateException("The inspector session is already connected");
        }
        InspectorExecutionContext execContext = this.contextSupplier.get();
        this.iss = InspectServerSession.create(execContext, false, new ConnectionWatcher());
        this.iss.open(this.getListeners());
        execContext.setSynchronous(true);
        this.iss.sendCommand(new Command("{\"id\":0,\"method\":\"Runtime.enable\"}"));
        return this.undefinedProvider.get();
    }

    private Object disconnect() {
        if (this.iss != null) {
            try {
                this.iss.sendClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.iss = null;
        }
        return this.undefinedProvider.get();
    }

    private Object addListener(Object[] arguments, boolean prepend) throws ArityException {
        Session.requireListenerArguments(arguments);
        this.getListeners().addListener(arguments[0], (TruffleObject)arguments[1], prepend);
        return this;
    }

    private Object addOnceListener(Object[] arguments, boolean prepend) throws ArityException {
        Session.requireListenerArguments(arguments);
        this.getListeners().addOnceListener(arguments[0], (TruffleObject)arguments[1], prepend);
        return this;
    }

    private Object removeListener(Object[] arguments) throws ArityException {
        Session.requireListenerArguments(arguments);
        this.getListeners().removeListener(arguments[0], (TruffleObject)arguments[1]);
        return this;
    }

    private static Object getEventName(Object[] arguments) {
        Object eventName = null;
        if (arguments.length > 0) {
            eventName = arguments[0];
        }
        return eventName;
    }

    private Object removeAllListeners(Object[] arguments) {
        Object eventName = Session.getEventName(arguments);
        this.getListeners().removeAll(eventName);
        return this;
    }

    private Object listeners(Object[] arguments) {
        Object eventName = Session.getEventName(arguments);
        return this.getListeners().listeners(eventName);
    }

    private Object listenerCount(Object[] arguments) {
        Object eventName = Session.getEventName(arguments);
        return this.getListeners().listenerCount(eventName);
    }

    private Object emit(Object[] arguments) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
        if (arguments.length < 1) {
            throw ArityException.create(1, -1, arguments.length);
        }
        Object eventName = arguments[0];
        Object[] listenerArgs = new Object[arguments.length - 1];
        System.arraycopy(arguments, 1, listenerArgs, 0, listenerArgs.length);
        return this.getListeners().emit(eventName, listenerArgs);
    }

    private Object post(Object[] arguments) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
        if (arguments.length < 1) {
            throw ArityException.create(1, -1, arguments.length);
        }
        if (!InteropLibrary.getUncached().isString(arguments[0])) {
            throw UnsupportedTypeException.create(new Object[]{arguments[0]});
        }
        String method = InteropLibrary.getUncached().asString(arguments[0]);
        TruffleObject params = null;
        TruffleObject callback = null;
        if (arguments.length >= 2) {
            if (!(arguments[1] instanceof TruffleObject)) {
                throw UnsupportedTypeException.create(new Object[]{arguments[1]});
            }
            TruffleObject to = (TruffleObject)arguments[1];
            if (InteropLibrary.getFactory().getUncached().isExecutable(to)) {
                callback = to;
            } else {
                params = to;
            }
            if (callback == null && arguments.length >= 3) {
                if (!(arguments[2] instanceof TruffleObject)) {
                    throw UnsupportedTypeException.create(new Object[]{arguments[2]});
                }
                callback = (TruffleObject)arguments[2];
            }
        }
        this.post(method, params, callback);
        return this.undefinedProvider.get();
    }

    private void post(String method, TruffleObject paramsObject, TruffleObject callback) {
        long id = this.cmdId.getAndIncrement();
        Params params = null;
        if (paramsObject != null) {
            params = new Params(TruffleObject2JSON.fromObject(paramsObject));
        }
        if (callback != null) {
            this.getListeners().addCallback(id, callback);
        }
        if (this.iss == null) {
            throw new InspectorStateException("The inspector session is not connected.");
        }
        this.iss.sendCommand(new Command(id, method, params));
    }

    private static boolean requireListenerArguments(Object[] arguments) throws ArityException {
        if (arguments.length < 2) {
            throw ArityException.create(2, -1, arguments.length);
        }
        if (!InteropLibrary.getFactory().getUncached().isExecutable(arguments[1])) {
            throw new IllegalArgumentException("The \"listener\" argument must be of type Function");
        }
        return true;
    }

    private Listeners getListeners() {
        Listeners l = this.listeners;
        if (l == null) {
            l = this.listeners = new Listeners(this.undefinedProvider);
        }
        return l;
    }

    static final class Listeners
    implements JSONMessageListener {
        private static final String EVENT_INSPECTOR = "inspectorNotification";
        private final Map<String, TruffleObject[]> listenersMap = new ConcurrentHashMap<String, TruffleObject[]>();
        private final Set<Object> eventNames = new LinkedHashSet<Object>();
        private final Map<Long, TruffleObject> callbacksMap = new ConcurrentHashMap<Long, TruffleObject>();
        private final UndefinedProvider undefinedProvider;

        Listeners(UndefinedProvider undefinedProvider) {
            this.undefinedProvider = undefinedProvider;
        }

        private void addOnceListener(Object eventName, TruffleObject listener, boolean prepend) {
            this.addListener(eventName, new AutoremoveListener(this, eventName, listener), prepend);
        }

        private synchronized void addListener(Object eventName, TruffleObject listener, boolean prepend) {
            CompilerAsserts.neverPartOfCompilation();
            String eventNameStr = eventName.toString();
            TruffleObject[] ls = this.listenersMap.get(eventNameStr);
            if (ls == null) {
                this.listenersMap.put(eventNameStr, new TruffleObject[]{listener});
            } else {
                TruffleObject[] nls;
                int l = ls.length;
                if (prepend) {
                    nls = new TruffleObject[l + 1];
                    System.arraycopy(ls, 0, nls, 1, l);
                    nls[0] = listener;
                } else {
                    nls = Arrays.copyOf(ls, l + 1);
                    nls[l] = listener;
                }
                this.listenersMap.put(eventNameStr, nls);
            }
            this.eventNames.add(eventName);
        }

        @CompilerDirectives.TruffleBoundary
        private synchronized void removeListener(Object eventName, TruffleObject listener) {
            String eventNameStr = eventName.toString();
            TruffleObject[] ls = this.listenersMap.get(eventNameStr);
            if (ls == null) {
                return;
            }
            TruffleObject[] nls = ls;
            for (int i = 0; i < ls.length; ++i) {
                if (listener != ls[i]) continue;
                if (ls.length == 1) {
                    nls = null;
                    break;
                }
                nls = new TruffleObject[ls.length - 1];
                System.arraycopy(ls, 0, nls, 0, i);
                System.arraycopy(ls, i + 1, nls, i, nls.length - i);
                break;
            }
            if (nls == null) {
                this.listenersMap.remove(eventNameStr);
            } else if (nls != ls) {
                this.listenersMap.put(eventNameStr, nls);
            }
        }

        private void removeAll(Object eventName) {
            if (eventName != null) {
                this.listenersMap.remove(eventName.toString());
                this.eventNames.remove(eventName);
            } else {
                this.listenersMap.clear();
                this.eventNames.clear();
            }
        }

        private Object listeners(Object eventName) {
            if (eventName != null) {
                Object[] ls = this.listenersMap.get(eventName.toString());
                if (ls == null) {
                    ls = new TruffleObject[]{};
                }
                return new JavaTruffleArray(ls);
            }
            ArrayList<TruffleObject> allListeners = new ArrayList<TruffleObject>();
            for (TruffleObject[] ls : this.listenersMap.values()) {
                for (int i = 0; i < ls.length; ++i) {
                    allListeners.add(ls[i]);
                }
            }
            return new JavaTruffleArray(allListeners.toArray());
        }

        private Object listenerCount(Object eventName) {
            if (eventName != null) {
                TruffleObject[] ls = this.listenersMap.get(eventName.toString());
                if (ls == null) {
                    return 0;
                }
                return ls.length;
            }
            int count = 0;
            for (TruffleObject[] ls : this.listenersMap.values()) {
                count += ls.length;
            }
            return count;
        }

        Object getEventNames() {
            return new JavaTruffleArray(this.eventNames.toArray());
        }

        void addCallback(long id, TruffleObject callback) {
            this.callbacksMap.put(id, callback);
        }

        @Override
        public void onMessage(JSONObject message) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
            String method = message.optString("method", null);
            if (method != null) {
                TruffleObject[] ls = this.listenersMap.get(method);
                JSONTruffleObject event = null;
                if (ls != null) {
                    event = new JSONTruffleObject(message);
                    Listeners.notify(ls, event);
                }
                if ((ls = this.listenersMap.get(EVENT_INSPECTOR)) != null) {
                    if (event == null) {
                        event = new JSONTruffleObject(message);
                    }
                    Listeners.notify(ls, event);
                }
            } else {
                TruffleObject callback;
                long id = message.optLong("id", -1L);
                if (id >= 0L && (callback = this.callbacksMap.remove(id)) != null) {
                    Object[] arguments = new Object[2];
                    JSONObject error = message.optJSONObject("error");
                    if (error != null) {
                        arguments[0] = new JSONTruffleObject(error);
                        arguments[1] = this.undefinedProvider.get();
                    } else {
                        JSONObject result = message.optJSONObject("result");
                        arguments[0] = this.undefinedProvider.get();
                        arguments[1] = result != null ? new JSONTruffleObject(result) : this.undefinedProvider.get();
                    }
                    InteropLibrary.getFactory().getUncached().execute(callback, arguments);
                }
            }
        }

        private static void notify(TruffleObject[] ls, TruffleObject event) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
            for (TruffleObject listener : ls) {
                InteropLibrary.getFactory().getUncached().execute(listener, event);
            }
        }

        public Object emit(Object eventName, Object[] listenerArgs) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
            TruffleObject[] ls = this.listenersMap.get(eventName.toString());
            if (ls == null) {
                return false;
            }
            for (TruffleObject listener : ls) {
                InteropLibrary.getFactory().getUncached().execute(listener, listenerArgs);
            }
            return true;
        }

        @ExportLibrary(value=InteropLibrary.class)
        static class AutoremoveListener
        implements TruffleObject {
            private final Listeners listeners;
            private final Object eventName;
            final TruffleObject listener;

            AutoremoveListener(Listeners listeners, Object eventName, TruffleObject listener) {
                this.listeners = listeners;
                this.eventName = eventName;
                this.listener = listener;
            }

            @ExportMessage
            boolean isExecutable() {
                return true;
            }

            @ExportMessage
            final Object execute(Object[] arguments, @CachedLibrary(value="this.listener") InteropLibrary library) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                this.listeners.removeListener(this.eventName, this);
                return library.execute(this.listener, arguments);
            }
        }
    }
}

