/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.debug.DebugException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.debug.DebugValue;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.LanguageInfo;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types.TypeInfo;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.utils.json.JSONArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.utils.json.JSONObject;

final class ObjectPreview {
    private static final int OVERFLOW_LIMIT_PROPERTIES = 5;
    private static final int OVERFLOW_LIMIT_ARRAY_ELEMENTS = 100;

    private ObjectPreview() {
    }

    static JSONObject create(DebugValue debugValue, TypeInfo.TYPE type, TypeInfo.SUBTYPE subtype, boolean allowToStringSideEffects, LanguageInfo language, PrintWriter err) {
        return ObjectPreview.create(debugValue, type, subtype, allowToStringSideEffects, language, err, false);
    }

    private static JSONObject create(DebugValue debugValue, boolean allowToStringSideEffects, LanguageInfo language, PrintWriter err, boolean isMapEntryKV) {
        TypeInfo typeInfo = TypeInfo.fromValue(debugValue, null, language, err);
        return ObjectPreview.create(debugValue, typeInfo.type, typeInfo.subtype, allowToStringSideEffects, language, err, isMapEntryKV);
    }

    private static JSONObject create(DebugValue debugValue, TypeInfo.TYPE type, TypeInfo.SUBTYPE subtype, boolean allowToStringSideEffects, LanguageInfo language, PrintWriter err, boolean isMapEntryKV) {
        boolean overflow;
        JSONObject json = new JSONObject();
        json.put("type", type.getId());
        if (subtype != null) {
            json.put("subtype", subtype.getId());
        }
        boolean isArray = debugValue.isArray();
        boolean isMap = debugValue.hasHashEntries();
        if (isMapEntryKV) {
            String valueStr = RemoteObject.toString(debugValue, allowToStringSideEffects, err);
            json.putOpt("description", valueStr);
        } else {
            DebugValue metaObject = RemoteObject.getMetaObject(debugValue, language, err);
            Object metaType = null;
            if (metaObject != null) {
                metaType = RemoteObject.toMetaName(metaObject, err);
                if (isArray) {
                    metaType = (String)metaType + "(" + debugValue.getArray().size() + ")";
                } else if (isMap) {
                    metaType = (String)metaType + "(" + debugValue.getHashSize() + ")";
                }
            }
            json.putOpt("description", metaType);
        }
        JSONArray properties = new JSONArray();
        JSONArray entries = new JSONArray();
        if (isArray) {
            List<DebugValue> array = debugValue.getArray();
            int size = array.size();
            overflow = size > 100;
            int n = Math.min(size, 100);
            for (int i = 0; i < n; ++i) {
                try {
                    properties.put(ObjectPreview.createPropertyPreview(array.get(i), allowToStringSideEffects, language, err));
                    continue;
                }
                catch (DebugException ex) {
                    overflow = true;
                    break;
                }
            }
        } else if (isMap && !isMapEntryKV) {
            DebugValue entriesIter = debugValue.getHashEntriesIterator();
            overflow = false;
            while (entriesIter.hasIteratorNextElement()) {
                JSONObject entryPreview;
                DebugValue entry = entriesIter.getIteratorNextElement();
                try {
                    entryPreview = ObjectPreview.createEntryPreview(entry, allowToStringSideEffects, language, err);
                }
                catch (DebugException ex) {
                    overflow = true;
                    break;
                }
                if (entryPreview == null) continue;
                if (entries.length() == 5) {
                    overflow = true;
                    break;
                }
                entries.put(entryPreview);
            }
        } else {
            Collection<DebugValue> valueProperties = debugValue.getProperties();
            if (valueProperties != null) {
                Iterator<DebugValue> propertyIterator = valueProperties.iterator();
                overflow = false;
                while (propertyIterator.hasNext()) {
                    DebugValue property = propertyIterator.next();
                    if (property.isInternal() || property.hasReadSideEffects() || !property.isReadable()) continue;
                    if (properties.length() == 5) {
                        overflow = true;
                        break;
                    }
                    try {
                        properties.put(ObjectPreview.createPropertyPreview(property, allowToStringSideEffects, language, err));
                    }
                    catch (DebugException ex) {
                        overflow = true;
                        break;
                    }
                }
            } else {
                overflow = false;
            }
        }
        json.put("overflow", overflow);
        json.put("properties", properties);
        if (isMap && !isMapEntryKV) {
            json.put("entries", entries);
        }
        return json;
    }

    private static JSONObject createPropertyPreview(DebugValue origProperty, boolean allowToStringSideEffects, LanguageInfo language, PrintWriter err) {
        Object value;
        DebugValue property = origProperty;
        if (language != null) {
            property = property.asInLanguage(language);
        }
        JSONObject json = new JSONObject();
        json.put("name", property.getName());
        boolean isArray = property.isArray();
        TypeInfo typeInfo = TypeInfo.fromValue(property, null, language, err);
        json.put("type", typeInfo.type.getId());
        if (typeInfo.subtype != null) {
            json.put("subtype", typeInfo.subtype.getId());
        }
        if (isArray) {
            String size = "(" + property.getArray().size() + ")";
            value = typeInfo.descriptionType != null ? typeInfo.descriptionType + size : size;
        } else {
            value = RemoteObject.toString(property, allowToStringSideEffects, err);
        }
        json.putOpt("value", value);
        return json;
    }

    private static JSONObject createEntryPreview(DebugValue entry, boolean allowToStringSideEffects, LanguageInfo language, PrintWriter err) {
        List<DebugValue> entryArray = entry.getArray();
        DebugValue key = entryArray.get(0);
        DebugValue value = entryArray.get(1);
        if (language != null) {
            key = key.asInLanguage(language);
            value = value.asInLanguage(language);
        }
        JSONObject json = new JSONObject();
        json.put("key", ObjectPreview.create(key, allowToStringSideEffects, language, err, true));
        json.put("value", ObjectPreview.create(value, allowToStringSideEffects, language, err, true));
        return json;
    }
}

