/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types;

import java.util.concurrent.TimeUnit;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.types.ProfileNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.utils.json.JSONArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.tools.utils.json.JSONObject;

public final class Profile {
    private final ProfileNode[] nodes;
    private final long startTime;
    private final long endTime;
    private final TimeLineItem[] timeLine;

    public Profile(ProfileNode[] nodes, long startTime, long endTime, TimeLineItem[] timeLine) {
        this.nodes = nodes;
        this.startTime = startTime;
        this.endTime = endTime;
        this.timeLine = timeLine;
    }

    public ProfileNode[] getNodes() {
        return this.nodes;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public TimeLineItem[] getTimeLine() {
        return this.timeLine;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("nodes", ProfileNode.toJSON(this.nodes));
        json.put("startTime", TimeUnit.MILLISECONDS.toMicros(this.startTime));
        json.put("endTime", TimeUnit.MILLISECONDS.toMicros(this.endTime));
        JSONArray samples = new JSONArray();
        JSONArray timeDeltas = new JSONArray();
        long lastTimestamp = this.startTime;
        for (TimeLineItem item : this.timeLine) {
            timeDeltas.put(TimeUnit.MILLISECONDS.toMicros(item.timestamp - lastTimestamp));
            samples.put(item.id);
            lastTimestamp = item.timestamp;
        }
        json.put("samples", samples);
        json.put("timeDeltas", timeDeltas);
        return json;
    }

    public static final class TimeLineItem {
        private final long timestamp;
        private final int id;

        public TimeLineItem(long timestamp, int id) {
            this.timestamp = timestamp;
            this.id = id;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int getId() {
            return this.id;
        }
    }
}

