/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.interpreter.compute.data;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kasuga.lib.vendor_modules.interpreter.Code;
import kasuga.lib.vendor_modules.interpreter.Utils;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import kasuga.lib.vendor_modules.interpreter.compute.data.Numeric;
import kasuga.lib.vendor_modules.interpreter.compute.data.Operational;
import kasuga.lib.vendor_modules.interpreter.compute.data.Variable;
import kasuga.lib.vendor_modules.interpreter.compute.data.functions.Function;
import kasuga.lib.vendor_modules.interpreter.compute.exceptions.FormulaParseError;
import kasuga.lib.vendor_modules.interpreter.compute.exceptions.FormulaSynatxError;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Assignable;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Pretreatable;

public class Line
implements Formula,
Assignable,
Pretreatable {
    private final List<Formula> elements;
    private final Namespace namespace;
    public static final String brackets_codec = "BRACKETS_CODEC";
    private boolean flip = false;

    public Line(Namespace namespace) {
        this.elements = new ArrayList<Formula>();
        this.namespace = namespace;
    }

    public Line(String line, Namespace namespace) {
        this(namespace);
        this.fromString(line);
    }

    public Line(List<Formula> elements, Namespace namespace) {
        this.elements = elements;
        this.namespace = namespace;
    }

    @Override
    public String getString() {
        StringBuilder builder = new StringBuilder();
        if (this.flip) {
            builder.append("-");
        }
        for (Formula formula : this.elements) {
            if (formula.isAtomic() || formula instanceof Function) {
                builder.append(formula.getString());
                continue;
            }
            builder.append("(").append(formula.getString()).append(")");
        }
        return builder.toString();
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public String getIdentifier() {
        return "line";
    }

    @Override
    public float getResult() {
        if (this.elements.isEmpty()) {
            return 0.0f;
        }
        if (this.elements.size() == 1) {
            if (this.elements instanceof Operational) {
                throw new FormulaSynatxError(this, 0);
            }
            return this.elements.get(0).getResult() * (float)(this.flip ? -1 : 1);
        }
        ArrayList<Formula> formulas = new ArrayList<Formula>(this.getElements());
        this.dealLeveledOperation(formulas, "^");
        this.dealLeveledOperation(formulas, "*", "/");
        this.dealLeveledOperation(formulas, "%");
        this.dealLeveledOperation(formulas, "+", "-");
        return formulas.get(0).getResult() * (float)(this.flip ? -1 : 1);
    }

    private void dealLeveledOperation(ArrayList<Formula> formulas, String ... operations) {
        ArrayList<Integer> indexList = this.getOperationsIndex(formulas, operations);
        int offset = 0;
        for (int index : indexList) {
            Operational opt = (Operational)formulas.get(index - offset);
            formulas.set(index - 1 - offset, new Numeric(opt.operate(formulas.get(index - 1 - offset), formulas.get(index + 1 - offset))));
            formulas.remove(index - offset);
            formulas.remove(index - offset);
            offset += 2;
        }
    }

    private ArrayList<Integer> getOperationsIndex(List<Formula> elements, String ... type) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int counter = 0;
        for (Formula formula : elements) {
            ++counter;
            if (!(formula instanceof Operational)) continue;
            for (String t : type) {
                if (!formula.getString().equals(t)) continue;
                result.add(counter - 1);
            }
        }
        return result;
    }

    @Override
    public void preTreatment() {
        Formula formula;
        if (this.elements.isEmpty()) {
            return;
        }
        while ((formula = this.elements.get(0)) instanceof Operational) {
            Operational operational = (Operational)formula;
            String str = operational.getString();
            if (!str.equals("+") && !str.equals("-")) {
                throw new FormulaSynatxError(this, 0);
            }
            if (str.equals("+")) {
                this.elements.remove(operational);
            }
            if (!str.equals("-")) continue;
            this.elements.add(0, new Numeric(0.0f));
        }
        int length = this.elements.size();
        if (this.elements.get(this.elements.size() - 1) instanceof Operational) {
            throw new FormulaSynatxError(this, this.elements.size() - 1);
        }
        if (length == 1) {
            this.subPreTreatment(this.elements.get(0));
        }
        for (int i = 1; i < length; ++i) {
            Formula formula2 = this.elements.get(i);
            Formula former = this.elements.get(i - 1);
            if (!(formula2 instanceof Operational) || !(former instanceof Operational)) continue;
            ((Operational)formula2).mergeOperation(former, this, i);
            this.elements.removeIf(Formula::shouldRemove);
            if (this.elements.size() == length) continue;
            i = 0;
            length = this.elements.size();
        }
        ArrayList<Integer> minusGroup = this.getOperationsIndex(this.elements, "-");
        ArrayList<Integer> markRemove = new ArrayList<Integer>();
        for (Integer index : minusGroup) {
            Formula formula3 = this.elements.get(index + 1);
            if (index == 0) {
                formula3.flipOutput(!formula3.isOutputFlipped());
                markRemove.add(0);
                continue;
            }
            if (!(this.elements.get(index - 1) instanceof Operational) || index >= this.elements.size() - 1) continue;
            formula3.flipOutput(!formula3.isOutputFlipped());
            markRemove.add(index);
        }
        for (int i = markRemove.size() - 1; i > -1; --i) {
            this.elements.remove((Integer)markRemove.get(i));
        }
    }

    private void subPreTreatment(Formula formula) {
        if (formula instanceof Pretreatable) {
            Pretreatable pretreatable = (Pretreatable)((Object)formula);
            pretreatable.preTreatment();
        }
    }

    @Override
    public List<Formula> getElements() {
        return this.elements;
    }

    @Override
    public boolean isAtomic() {
        return this.elements.size() <= 1;
    }

    @Override
    public boolean shouldRemove() {
        return this.elements.isEmpty();
    }

    @Override
    public void fromString(String string) {
        string = ((String)string).replaceAll(" ", "");
        HashMap<CallSite, String> inners = new HashMap<CallSite, String>();
        if (((String)string).contains("(") || ((String)string).contains(")")) {
            if (!Utils.checkBrackets((String)string)) {
                throw new FormulaSynatxError(this, 0);
            }
            while (Utils.containsBrackets((String)string)) {
                int index = inners.size();
                int[] pos = Utils.positionBrackets((String)string);
                for (String funcCodec : this.namespace.functions().keySet()) {
                    int index2 = ((String)string).indexOf(funcCodec);
                    if (index2 == -1 || index2 != pos[0] - funcCodec.length()) continue;
                    pos[0] = pos[0] - funcCodec.length();
                    break;
                }
                inners.put((CallSite)((Object)(brackets_codec + index)), ((String)string).substring(pos[0], pos[1] + 1));
                string = ((String)string).substring(0, pos[0]) + brackets_codec + index + ((String)string).substring(pos[1] + 1);
            }
        }
        Matcher matcher = this.matcher((String)string);
        String copy = String.copyValueOf(((String)string).toCharArray());
        ArrayList<Object> formulaGroup = new ArrayList<Object>();
        int skip = 0;
        block2: while (matcher.find()) {
            if (skip > 0) {
                --skip;
                continue;
            }
            String str = matcher.group();
            if (str.startsWith(brackets_codec)) {
                String sys = inners.getOrDefault(str, null);
                if (sys == null) {
                    throw new FormulaSynatxError(this, matcher.start());
                }
                if (sys.startsWith("(")) {
                    Line subLine = new Line(this.namespace);
                    subLine.fromString(sys.substring(1, sys.length() - 1));
                    formulaGroup.add(subLine);
                    copy = copy.replaceFirst(str, "TOKEN" + (formulaGroup.size() - 1));
                    continue;
                }
                for (String codec : this.namespace.functions().keySet()) {
                    if (!sys.startsWith(codec)) continue;
                    Function function = this.namespace.createFunctionInstance(codec);
                    function.fromString(sys.substring(sys.indexOf("(") + 1, sys.length() - 1));
                    formulaGroup.add(function);
                    copy = copy.replaceFirst(str, "TOKEN" + (formulaGroup.size() - 1));
                    continue block2;
                }
                continue;
            }
            Formula formula = null;
            String var = str;
            if (Numeric.isNumber(str)) {
                formula = new Numeric(str);
            } else if (Variable.isVar(str)) {
                if (matcher.end() < ((String)string).length() - 1 && ((String)string).charAt(matcher.end()) == '.') {
                    String cache = ((String)string).substring(matcher.end());
                    var = this.findLongVar(cache, str, 0);
                    skip = var.split("\\.").length - 1;
                }
                if (this.namespace.containsInstance(var)) {
                    formula = (Variable)this.namespace.getInstance(var);
                } else {
                    formula = new Variable(var, this.namespace, 0.0f);
                    this.namespace.registerInstance(var, (Variable)formula);
                }
            }
            if (formula != null) {
                formulaGroup.add(formula);
                copy = copy.replaceFirst(var, "TOKEN" + (formulaGroup.size() - 1));
                continue;
            }
            throw new FormulaParseError(new FormulaSynatxError(this, matcher.start()), (String)string);
        }
        int operationIndex = Operational.getOperationIndex(copy);
        if (operationIndex == -1) {
            this.elements.addAll(formulaGroup);
        } else {
            while (operationIndex > -1) {
                String opt = String.valueOf(copy.charAt(operationIndex));
                String former = copy.substring(0, operationIndex);
                if (!former.equals("")) {
                    int idx = Integer.parseInt(former.replaceAll("TOKEN", ""));
                    this.elements.add((Formula)formulaGroup.get(idx));
                }
                this.elements.add(new Operational(opt));
                copy = copy.substring(operationIndex + 1);
                operationIndex = Operational.getOperationIndex(copy);
            }
            int idx = Integer.parseInt(copy.replaceAll("TOKEN", ""));
            this.elements.add((Formula)formulaGroup.get(idx));
            this.preTreatment();
        }
    }

    public ArrayList<String> generateFunctionList() {
        ArrayList<String> result = new ArrayList<String>();
        block0: for (String string : Code.getFunctions().keySet()) {
            if (result.isEmpty()) {
                result.add(string);
                continue;
            }
            int l1 = string.length();
            if (result.get(0).length() <= l1) {
                result.add(0, string);
                continue;
            }
            for (String x : result) {
                int index = result.indexOf(x);
                if (index == result.size() - 1) {
                    result.add(string);
                    continue block0;
                }
                int l2 = x.length();
                if (result.get(index + 1).length() > l1 || l2 < l1) continue;
                result.add(index + 1, string);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public Line clone() {
        return new Line(new ArrayList<Formula>(this.elements), this.namespace.clone());
    }

    @Override
    public void flipOutput(boolean flip) {
        this.flip = flip;
    }

    @Override
    public boolean isOutputFlipped() {
        return this.flip;
    }

    public Matcher matcher(String input) {
        Pattern pattern = Pattern.compile("(\\d+(\\.\\d+)?)|(([a-z])([a-z1-9])*(_([a-z1-9]+))*)|(BRACKETS_CODEC+(\\d+))");
        return pattern.matcher(input);
    }

    public Matcher varMatcher(String input) {
        Pattern pattern = Pattern.compile("(([a-z])([a-z1-9])*(_([a-z1-9]+))*)");
        return pattern.matcher(input);
    }

    public String findLongVar(String input, String starter, int start_index) {
        String current = "";
        Matcher matcher = this.varMatcher(input);
        StringBuilder starterBuilder = new StringBuilder(starter);
        while (matcher.find()) {
            current = matcher.group();
            if (start_index + 1 >= input.length() || matcher.start() != start_index + 1 || input.charAt(start_index) != '.') break;
            starterBuilder.append(".").append(current);
            start_index = matcher.end();
        }
        return starterBuilder.toString();
    }

    @Override
    public Set<String> variableCodecs() {
        return this.namespace.instanceNames();
    }

    @Override
    public void assign(String codec, float value) {
        if (!this.containsVar(codec)) {
            return;
        }
        Assignable assignable = this.namespace.getInstance(codec);
        assignable.assign(codec, value);
    }

    @Override
    public boolean containsVar(String codec) {
        return this.namespace.containsInstance(codec);
    }

    @Override
    public float getValue(String codec) {
        if (!this.containsVar(codec)) {
            throw new FormulaSynatxError(this, 0);
        }
        return this.namespace.getInstance(codec).getValue(codec);
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean hasVar() {
        return this.namespace.instanceVarSize() > 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Line)) {
            return false;
        }
        Line line = (Line)obj;
        return this.toString().equals(line.toString());
    }
}

