/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.interpreter.logic.data;

import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Assignable;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;
import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalAssignable;
import kasuga.lib.vendor_modules.interpreter.logic.infrastructure.LogicalData;

public class LogicalNumeric
implements LogicalData,
LogicalAssignable {
    private final Formula formula;
    private final Namespace namespace;

    public LogicalNumeric(Formula formula) {
        this.formula = formula;
        if (formula instanceof Assignable) {
            Assignable assignable = (Assignable)((Object)formula);
            this.namespace = assignable.getNamespace();
        } else {
            this.namespace = null;
        }
    }

    public LogicalNumeric(String formulaString, Namespace namespace) {
        this.formula = namespace.decodeFormula(formulaString);
        this.namespace = namespace;
    }

    @Override
    public boolean getResult() {
        return (int)this.mathResult() != 0;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public void assign(String codec, float value) {
        if (this.isAssignable()) {
            ((Assignable)((Object)this.formula)).assign(codec, value);
        }
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public String toString() {
        return this.formula.getString();
    }

    @Override
    public boolean isAssignable() {
        return this.namespace != null;
    }

    @Override
    public LogicalNumeric clone() {
        return new LogicalNumeric(this.formula.clone());
    }

    public float mathResult() {
        return this.formula.getResult();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LogicalNumeric)) {
            return false;
        }
        LogicalNumeric numeric = (LogicalNumeric)obj;
        return this.formula.equals(numeric.formula);
    }
}

