/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.AtlasResources;
import kasuga.lib.core.KasugaLibClient;
import kasuga.lib.core.base.CustomBlockRenderer;
import kasuga.lib.core.base.commands.ArgumentTypes.BaseArgument;
import kasuga.lib.core.base.commands.ArgumentTypes.BaseArgumentInfo;
import kasuga.lib.core.client.animation.Constants;
import kasuga.lib.core.client.frontend.gui.GuiEngine;
import kasuga.lib.core.client.render.texture.old.SimpleTexture;
import kasuga.lib.core.events.both.BothSetupEvent;
import kasuga.lib.core.events.both.EntityAttributeEvent;
import kasuga.lib.core.events.client.ClientSetupEvent;
import kasuga.lib.core.events.client.ClientTickEvent;
import kasuga.lib.core.events.client.ModelRegistryEvent;
import kasuga.lib.core.events.client.PacketEvent;
import kasuga.lib.core.events.client.RenderTickEvent;
import kasuga.lib.core.events.client.TextureRegistryEvent;
import kasuga.lib.core.events.server.ServerResourceListener;
import kasuga.lib.core.events.server.ServerStartingEvents;
import kasuga.lib.core.javascript.JavascriptApi;
import kasuga.lib.core.util.Envs;
import kasuga.lib.registrations.client.KeyBindingReg;
import kasuga.lib.registrations.registry.FontRegistry;
import kasuga.lib.registrations.registry.SimpleRegistry;
import kasuga.lib.registrations.registry.TextureRegistry;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class KasugaLibStacks {
    private static final HashSet<String> registeredNamespaces = new HashSet();
    private final HashMap<String, SimpleRegistry> registries;
    public final IEventBus bus;
    private final DeferredRegister<ArgumentTypeInfo<?, ?>> ARGUMENT_TYPES;
    private boolean hasTextureRegistryFired = false;
    private final TextureRegistry TEXTURES;
    private final FontRegistry FONTS;
    private final RandomSource random = RandomSource.m_216327_();
    private final HashMap<Block, CustomBlockRenderer> BLOCK_RENDERERS;
    public final JavascriptApi JAVASCRIPT = new JavascriptApi();
    public Optional<GuiEngine> GUI = Optional.empty();
    public static final SimpleRegistry REGISTRY = new SimpleRegistry("kasuga_lib", KasugaLib.EVENTS);

    public KasugaLibStacks(IEventBus bus) {
        this.bus = bus;
        this.registries = new HashMap();
        KeyBindingReg.invoke();
        this.ARGUMENT_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.COMMAND_ARGUMENT_TYPES, (String)"kasuga_lib");
        this.ARGUMENT_TYPES.register("base", () -> (BaseArgumentInfo)ArgumentTypeInfos.registerByClass(BaseArgument.class, (ArgumentTypeInfo)new BaseArgumentInfo()));
        this.ARGUMENT_TYPES.register(bus);
        this.TEXTURES = new TextureRegistry("kasuga_lib");
        this.FONTS = new FontRegistry("kasuga_lib");
        this.BLOCK_RENDERERS = new HashMap();
        MinecraftForge.EVENT_BUS.addListener(ServerStartingEvents::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(ServerStartingEvents::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(PacketEvent::onServerPayloadHandleEvent);
        bus.addListener(BothSetupEvent::onFMLCommonSetup);
        bus.addListener(EntityAttributeEvent::entityAttributeCreation);
        bus.addListener(BothSetupEvent::RegisterKeyEvent);
        if (Envs.isClient()) {
            MinecraftForge.EVENT_BUS.addListener(PacketEvent::onClientPayloadHandleEvent);
            MinecraftForge.EVENT_BUS.addListener(Constants::onClientTick);
            MinecraftForge.EVENT_BUS.addListener(Constants::onAnimStart);
            MinecraftForge.EVENT_BUS.addListener(Constants::onAnimStop);
            MinecraftForge.EVENT_BUS.addListener(ClientTickEvent::onClientTick);
            bus.addListener(ModelRegistryEvent::registerAdditionalModels);
            bus.addListener(ModelRegistryEvent::bakingCompleted);
            bus.addListener(TextureRegistryEvent::onModelRegistry);
            bus.addListener(ClientSetupEvent::onClientSetup);
            MinecraftForge.EVENT_BUS.addListener(RenderTickEvent::onRenderTick);
            this.GUI = Optional.of(new GuiEngine());
            KasugaLibClient.invoke();
        }
        MinecraftForge.EVENT_BUS.addListener(ServerResourceListener::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(ServerResourceListener::onServerStopping);
    }

    public static void registerNamespace(SimpleRegistry registry) {
        registeredNamespaces.add(registry.namespace);
    }

    public static HashSet<AtlasResources> getAdditionAtlasManager() {
        HashSet<AtlasResources> result = new HashSet<AtlasResources>();
        registeredNamespaces.forEach(namespace -> result.add(new AtlasResources((String)namespace)));
        return result;
    }

    public void stackIn(SimpleRegistry registry) {
        this.registries.put(registry.namespace, registry);
    }

    public boolean isTextureRegistryFired() {
        return this.hasTextureRegistryFired;
    }

    public void fireTextureRegistry() {
        this.hasTextureRegistryFired = true;
        this.TEXTURES.onRegister();
    }

    public void cacheBlockRendererIn(Block block, CustomBlockRenderer blockRenderer) {
        this.BLOCK_RENDERERS.put(block, blockRenderer);
    }

    public CustomBlockRenderer getBlockRenderer(Block block) {
        return this.BLOCK_RENDERERS.getOrDefault(block, null);
    }

    public HashMap<String, SimpleRegistry> getRegistries() {
        return this.registries;
    }

    public void putUnregisteredPicIn(SimpleTexture pic) {
        this.TEXTURES.stackIn(pic);
    }

    public FontRegistry fontRegistry() {
        return this.FONTS;
    }

    public RandomSource random() {
        return this.random;
    }
}

