/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import kasuga.lib.core.annos.Util;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Util
public class VectorUtil {
    public static Vec3 rot(Axis axis, Vec3 org, float rot, boolean degree) {
        Vector3f org3f = VectorUtil.vec3ToVec3f(org);
        Quaternionf quaternionf = degree ? VectorUtil.fromXYZDegrees(org3f) : VectorUtil.fromXYZ(org3f);
        quaternionf.mul((Quaternionfc)(degree ? axis.m_252977_(rot) : axis.m_252961_(rot)));
        return VectorUtil.vec3fToVec3(degree ? VectorUtil.toXYZDegrees(quaternionf) : VectorUtil.toXYZ(quaternionf));
    }

    public static Quaternionf rotQuaternionf(Quaternionf org, Quaternionf rot) {
        Quaternionf quaternionf = new Quaternionf((Quaternionfc)org);
        quaternionf.mul((Quaternionfc)rot);
        return quaternionf;
    }

    public static Vec3 rot(Vec3 org, Vec3 rot, boolean degree) {
        Vector3f org3f = VectorUtil.vec3ToVec3f(org);
        Vector3f rot3f = VectorUtil.vec3ToVec3f(rot);
        Quaternionf orgQ = degree ? VectorUtil.fromXYZDegrees(org3f) : VectorUtil.fromXYZ(org3f);
        Quaternionf rotQ = degree ? VectorUtil.fromXYZDegrees(rot3f) : VectorUtil.fromXYZ(rot3f);
        orgQ.mul((Quaternionfc)rotQ);
        return VectorUtil.vec3fToVec3(degree ? VectorUtil.toXYZDegrees(orgQ) : VectorUtil.toXYZ(orgQ));
    }

    public static Quaternionf getQuaternionf(Vec3 rot, boolean degree) {
        Vector3f vector3f = VectorUtil.vec3ToVec3f(rot);
        return degree ? VectorUtil.fromXYZDegrees(vector3f) : VectorUtil.fromXYZ(vector3f);
    }

    public static Vec3 degToRad(Vec3 deg) {
        return deg.m_82490_(Math.PI / 180);
    }

    public static Vec3 radToDeg(Vec3 rad) {
        return rad.m_82490_(57.29577951308232);
    }

    public static Vec3 rotX(Vec3 org, float rot, boolean degree) {
        return VectorUtil.rot(Axis.f_252529_, org, rot, degree);
    }

    public static Vec3 rotY(Vec3 org, float rot, boolean degree) {
        return VectorUtil.rot(Axis.f_252436_, org, rot, degree);
    }

    public static Vec3 rotZ(Vec3 org, float rot, boolean degree) {
        return VectorUtil.rot(Axis.f_252403_, org, rot, degree);
    }

    public static Vec3 rotXDeg(Vec3 org, float rot) {
        return VectorUtil.rotX(org, rot, true);
    }

    public static Vec3 rotYDeg(Vec3 org, float rot) {
        return VectorUtil.rotY(org, rot, true);
    }

    public static Vec3 rotZDeg(Vec3 org, float rot) {
        return VectorUtil.rotZ(org, rot, true);
    }

    public static Vec3 rotXRad(Vec3 org, float rot) {
        return VectorUtil.rotX(org, rot, false);
    }

    public static Vec3 rotYRad(Vec3 org, float rot) {
        return VectorUtil.rotY(org, rot, false);
    }

    public static Vec3 rotZRad(Vec3 org, float rot) {
        return VectorUtil.rotZ(org, rot, false);
    }

    public static void translate(PoseStack pose, Vec3 vec3) {
        pose.m_85837_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
    }

    public static void rot(PoseStack pose, Vec3 rotation, boolean degree) {
        pose.m_252781_(VectorUtil.getQuaternionf(rotation, degree));
    }

    public static float translateDegAndRad(float rot, boolean toDeg) {
        return toDeg ? rot * 180.0f / (float)Math.PI : rot * (float)Math.PI / 180.0f;
    }

    public static Vec3 translateDegAndRad(Vec3 rot, boolean toDeg) {
        return toDeg ? rot.m_82490_(57.29577951308232) : rot.m_82490_(Math.PI / 180);
    }

    public static void scale(PoseStack pose, Vec3 scale) {
        pose.m_85841_((float)scale.m_7096_(), (float)scale.m_7098_(), (float)scale.m_7094_());
    }

    public static Vec3 normalize(Vec3 vec3) {
        return vec3.m_82490_(1.0 / vec3.m_82553_());
    }

    public static double cosVector(Vec3 vec1, Vec3 vec2) {
        double factor1 = vec1.m_82526_(vec2);
        double factor2 = Math.sqrt(vec2.m_82556_() * vec1.m_82556_());
        return factor1 / factor2;
    }

    public static Vec3 normalBetween(Vec3 vec1, Vec3 vec2) {
        double cosine = VectorUtil.cosVector(vec1, vec2);
        double scale = vec1.m_82553_() * cosine;
        Vec3 vec = vec2.m_82490_(scale * vec1.m_82553_() / vec2.m_82553_());
        return vec1.m_82546_(vec);
    }

    public static Vec3 mirror(Vec3 axis, Vec3 vector) {
        if (axis.m_82526_(vector) == 0.0) {
            return vector;
        }
        Vec3 normal = VectorUtil.normalBetween(vector, axis);
        return vector.m_82549_(normal.m_82490_(2.0));
    }

    public static Vector3f vec3ToVec3f(Vec3 vec3) {
        return vec3.m_252839_();
    }

    public static Vec3 vec3fToVec3(Vector3f vector3f) {
        return new Vec3(vector3f);
    }

    public static Quaternionf fromXYZ(Vector3f rotations) {
        Quaternionf quaternionf = new Quaternionf();
        quaternionf.rotateXYZ(rotations.x(), rotations.y(), rotations.z());
        return quaternionf;
    }

    public static Quaternionf fromXYZ(float x, float y, float z) {
        return VectorUtil.fromXYZ(new Vector3f(x, y, z));
    }

    public static Quaternionf fromXYZDegrees(Vector3f rotations) {
        Vector3f rad = new Vector3f((Vector3fc)rotations);
        rad.mul((float)Math.PI / 180);
        return VectorUtil.fromXYZ(rad);
    }

    public static Vector3f toXYZ(Quaternionf quaternionf) {
        float f = quaternionf.w() * quaternionf.w();
        float f1 = quaternionf.x() * quaternionf.x();
        float f2 = quaternionf.y() * quaternionf.y();
        float f3 = quaternionf.z() * quaternionf.z();
        float f4 = f + f1 + f2 + f3;
        float f5 = 2.0f * quaternionf.w() * quaternionf.x() - 2.0f * quaternionf.y() * quaternionf.z();
        float f6 = (float)Math.asin(f5 / f4);
        return Math.abs(f5) > 0.999f * f4 ? new Vector3f(2.0f * (float)Math.atan2(quaternionf.x(), quaternionf.w()), f6, 0.0f) : new Vector3f((float)Math.atan2(2.0f * quaternionf.y() * quaternionf.z() + 2.0f * quaternionf.x() * quaternionf.w(), f - f1 - f2 + f3), f6, (float)Math.atan2(2.0f * quaternionf.x() * quaternionf.y() + 2.0f * quaternionf.w() * quaternionf.z(), f + f1 - f2 - f3));
    }

    public static Vector3f toXYZDegrees(Quaternionf quaternionf) {
        Vector3f vector3f = VectorUtil.toXYZ(quaternionf);
        return new Vector3f((float)Math.toDegrees(vector3f.x()), (float)Math.toDegrees(vector3f.y()), (float)Math.toDegrees(vector3f.z()));
    }
}

