/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.font;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import kasuga.lib.core.client.frontend.rendering.RenderContext;
import net.minecraft.client.gui.Font;
import net.minecraft.world.phys.Vec2;

public class FontHelper {
    public static void draw(Font font, RenderContext context, Vec2 originalPoint, int fontHeight, String text, int color) {
        FontHelper.draw(font, context, originalPoint, fontHeight, text, color, 1.0f);
    }

    public static void draw(Font font, RenderContext context, Vec2 originalPoint, int fontHeight, String text, int color, float fontWidthScale) {
        float f = fontHeight;
        Objects.requireNonNull(font);
        float yScale = f / 9.0f;
        float xScale = fontWidthScale * yScale;
        PoseStack pose = context.pose();
        pose.m_85836_();
        pose.m_252880_(originalPoint.f_82470_, originalPoint.f_82471_, 0.0f);
        pose.m_85841_(xScale, yScale, 0.0f);
        context.guiGraphics().m_280488_(font, text, 0, 0, color);
        pose.m_85849_();
    }

    public static Vec2 measure(Font font, int fontHeight, String text, float fontWidthScale) {
        float f = fontHeight;
        Objects.requireNonNull(font);
        float yScale = f / 9.0f;
        float xScale = fontWidthScale * yScale;
        float f2 = xScale * (float)font.m_92895_(text);
        Objects.requireNonNull(font);
        return new Vec2(f2, yScale * 9.0f);
    }
}

