/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.canvas.glfw;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import kasuga.lib.core.client.frontend.gui.canvas.glfw.CanvasRenderType;
import kasuga.lib.core.util.Callback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import org.joml.Matrix4f;

public class CanvasRenderer {
    RenderBuffers renderBuffer = Minecraft.m_91087_().m_91269_();
    TextureTarget target = new TextureTarget(256, 256, true, Minecraft.f_91002_);
    Queue<Callback> taskQueue = new ArrayDeque<Callback>();
    private AtomicBoolean shouldClear;

    public void init() {
        this.target.m_83950_(256, 256, false);
        this.target.m_83931_(0.0f, 1.0f, 0.0f, 1.0f);
        this.target.m_83954_(true);
    }

    public void render() {
        if (this.shouldClear.get()) {
            this.target.m_83954_(true);
        }
        RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
        this.target.m_83947_(true);
        RenderSystem.enableBlend();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Matrix4f matrix4f = CanvasRenderer.orthographic(0.0f, 256.0f, 0.0f, 256.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)RenderSystem.getVertexSorting());
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_166856_();
        poseStack.m_85837_(0.0, 0.0, -2000.0);
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
        this.actualRender();
        this.target.m_83970_();
        RenderSystem.disableBlend();
        RenderSystem.disableBlend();
        RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
    }

    public void renderToBuffer(MultiBufferSource.BufferSource bufferSource, int x, int y, int width, int height) {
        VertexConsumer consumer = bufferSource.m_6299_(CanvasRenderType.CANVAS.apply(this.target.m_83975_()));
        consumer.m_5483_((double)x, (double)(y + height), 0.0).m_7421_(0.0f, 1.0f).m_5752_();
        consumer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_(1.0f, 1.0f).m_5752_();
        consumer.m_5483_((double)(x + width), (double)y, 0.0).m_7421_(1.0f, 0.0f).m_5752_();
        consumer.m_5483_((double)x, (double)y, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
        bufferSource.m_109911_();
    }

    public void renderToScreen(int x, int y, int width, int height) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (int)this.target.m_83975_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)x, (double)y, 0.0).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, 0.0).m_7421_(1.0f, 1.0f).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
        RenderSystem.disableBlend();
    }

    private void actualRender() {
        MultiBufferSource.BufferSource bufferSource = this.renderBuffer.m_110104_();
        while (!this.taskQueue.isEmpty()) {
            this.taskQueue.poll().execute();
        }
        bufferSource.m_109911_();
    }

    public void close() {
        this.target.m_83930_();
    }

    public void pushTask(Callback drawFunction) {
        this.taskQueue.add(drawFunction);
    }

    public static Matrix4f orthographic(float pMinX, float pMaxX, float pMinY, float pMaxY, float pMinZ, float pMaxZ) {
        Matrix4f matrix4f = new Matrix4f();
        float f = pMaxX - pMinX;
        float f1 = pMinY - pMaxY;
        float f2 = pMaxZ - pMinZ;
        matrix4f.m00(2.0f / f);
        matrix4f.m11(2.0f / f1);
        matrix4f.m22(-2.0f / f2);
        matrix4f.m03(-(pMaxX + pMinX) / f);
        matrix4f.m13(-(pMinY + pMaxY) / f1);
        matrix4f.m23(-(pMaxZ + pMinZ) / f2);
        matrix4f.m33(1.0f);
        return matrix4f;
    }
}

