/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.nodes;

import java.util.Optional;
import kasuga.lib.core.client.frontend.common.layouting.LayoutBox;
import kasuga.lib.core.client.frontend.common.layouting.LayoutContext;
import kasuga.lib.core.client.frontend.common.layouting.LayoutNode;
import kasuga.lib.core.client.frontend.dom.attribute.AttributeProxy;
import kasuga.lib.core.client.frontend.font.FontHelper;
import kasuga.lib.core.client.frontend.gui.GuiContext;
import kasuga.lib.core.client.frontend.gui.layout.yoga.MayMeasurable;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaMeasureFunction;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaMeasureMode;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaMeasureOutput;
import kasuga.lib.core.client.frontend.gui.nodes.GuiDomNode;
import kasuga.lib.core.client.frontend.rendering.RenderContext;
import kasuga.lib.core.util.LazyRecomputable;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.world.phys.Vec2;

public class GuiTextNode
extends GuiDomNode
implements MayMeasurable {
    Font font;
    String content;
    LazyRecomputable<Pair<Integer, Integer>> measureResult;

    GuiTextNode(GuiContext context) {
        super(context);
        this.font = Minecraft.m_91087_().f_91062_;
        this.content = "";
        this.measureResult = LazyRecomputable.of(() -> {
            Vec2 measureResult = FontHelper.measure(Minecraft.m_91087_().f_91062_, (Integer)this.fontSize.get(), this.content, 1.0f);
            return Pair.of((int)measureResult.f_82470_, (int)measureResult.f_82471_);
        });
        this.attributes.registerProxy("content", new AttributeProxy(){

            @Override
            public String get() {
                return GuiTextNode.this.content;
            }

            @Override
            public String set(String value) {
                GuiTextNode.this.content = value;
                GuiTextNode.this.getLayoutManager().markDirty();
                return value;
            }
        });
    }

    @Override
    public void render(Object source, RenderContext context) {
        super.render(source, context);
        LayoutNode layout = this.getLayoutManager().getSourceNode(source);
        LayoutBox box = layout.getPosition();
        FontHelper.draw(Minecraft.m_91087_().f_91062_, context, new Vec2(box.x, box.y), (Integer)this.fontSize.get(), this.content, -16777216);
    }

    @Override
    public Optional<YogaMeasureFunction> measure() {
        return Optional.of((node, width, widthMode, height, heightMode) -> {
            float finalWidth;
            Pair<Integer, Integer> result = this.measureResult.get();
            int measuredWidth = result.getFirst();
            int measuredHeight = result.getSecond();
            float f = widthMode == YogaMeasureMode.EXACTLY ? width : (finalWidth = widthMode == YogaMeasureMode.AT_MOST ? Math.min(width, (float)measuredWidth) : (float)measuredWidth);
            float finalHeight = heightMode == YogaMeasureMode.EXACTLY ? height : (heightMode == YogaMeasureMode.AT_MOST ? Math.min(height, (float)measuredHeight) : (float)measuredHeight);
            return YogaMeasureOutput.make(finalWidth, finalHeight);
        });
    }

    @Override
    protected void fontSizeUpdated() {
        this.measureResult.clear();
        ((LayoutContext)this.layoutManager.get()).markDirty();
    }
}

