/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.styles.layout;

import java.util.Map;
import kasuga.lib.core.client.frontend.common.style.Style;
import kasuga.lib.core.client.frontend.common.style.StyleTarget;
import kasuga.lib.core.client.frontend.common.style.StyleType;
import kasuga.lib.core.client.frontend.gui.layout.yoga.api.YogaEdge;

public class BorderStyle
extends Style<Float, StyleTarget> {
    public final String original;
    public final Float value;
    public final YogaEdge edge;
    public StyleTarget target;

    public BorderStyle(YogaEdge edge, float value) {
        this.value = Float.valueOf(value);
        this.original = String.valueOf(value);
        this.createTarget();
        this.edge = edge;
    }

    public static StyleType<?, StyleTarget> createType(YogaEdge yogaEdge) {
        return new BorderStyleType(yogaEdge);
    }

    private void createTarget() {
        this.target = StyleTarget.LAYOUT_NODE.create(node -> {
            if (!this.isValid((Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>>)null)) {
                return;
            }
            node.setBorder(this.edge, this.value.floatValue());
        });
    }

    public BorderStyle(YogaEdge edge, String source) {
        Float _value;
        this.original = source;
        try {
            _value = Float.valueOf(Float.parseFloat(source));
        }
        catch (NumberFormatException e) {
            _value = null;
        }
        this.edge = edge;
        this.value = _value;
        this.createTarget();
    }

    @Override
    public boolean isValid(Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>> origin) {
        return this.value != null;
    }

    @Override
    public StyleType<?, StyleTarget> getType() {
        return null;
    }

    @Override
    public StyleTarget getTarget() {
        return this.target;
    }

    @Override
    public Float getValue() {
        return this.value;
    }

    @Override
    public String getValueString() {
        return String.valueOf(this.value);
    }

    public static class BorderStyleType
    implements StyleType<BorderStyle, StyleTarget> {
        protected final BorderStyle EMPTY;
        public final YogaEdge edge;

        public BorderStyleType(YogaEdge edge) {
            this.edge = edge;
            this.EMPTY = new BorderStyle(edge, 0.0f);
        }

        @Override
        public BorderStyle getDefault() {
            return this.EMPTY;
        }

        @Override
        public BorderStyle create(String source) {
            return new BorderStyle(this.edge, source);
        }

        public BorderStyle create(float value) {
            return new BorderStyle(this.edge, value);
        }
    }
}

