/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.frontend.gui.styles.node;

import java.util.InputMismatchException;
import java.util.Map;
import java.util.Scanner;
import kasuga.lib.core.client.frontend.common.style.Style;
import kasuga.lib.core.client.frontend.common.style.StyleTarget;
import kasuga.lib.core.client.frontend.common.style.StyleType;
import kasuga.lib.core.client.frontend.gui.styles.node.SimpleNodeStyleType;

public class BackgroundNineSliceParam
extends Style<float[], StyleTarget> {
    public static final StyleType<BackgroundNineSliceParam, StyleTarget> TYPE = SimpleNodeStyleType.of(BackgroundNineSliceParam::new, "0 0");
    public static final BackgroundNineSliceParam EMPTY = new BackgroundNineSliceParam();
    String uvString = "";
    boolean valid = false;
    float borderSize;
    float borderScale;
    float[] value = new float[2];

    public BackgroundNineSliceParam(String uv) {
        int pointer;
        float[] positions = new float[2];
        this.uvString = uv;
        try (Scanner scanner = new Scanner(uv);){
            for (pointer = 0; scanner.hasNext() && pointer < 2; ++pointer) {
                positions[pointer] = scanner.nextFloat();
            }
        }
        catch (InputMismatchException mismatchException) {
            return;
        }
        if (pointer != 2) {
            return;
        }
        this.borderSize = positions[0];
        this.borderScale = positions[1];
        this.value = positions;
        this.valid = true;
    }

    public BackgroundNineSliceParam() {
    }

    @Override
    public boolean isValid(Map<StyleType<?, StyleTarget>, Style<?, StyleTarget>> origin) {
        return this.valid;
    }

    @Override
    public StyleType<?, StyleTarget> getType() {
        return TYPE;
    }

    @Override
    public StyleTarget getTarget() {
        return StyleTarget.GUI_DOM_NODE.create(node -> node.getBackgroundRenderer().setNineSlicedParam(this.borderSize, this.borderScale));
    }

    @Override
    public String getValueString() {
        return this.uvString;
    }

    @Override
    public float[] getValue() {
        return this.value;
    }
}

