/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RenderableItem {
    private final ItemStack stack;
    private Font font;
    private boolean renderCount = false;
    private int width = 16;
    private int height = 16;

    public RenderableItem(ItemStack stack) {
        this.stack = stack;
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public RenderableItem(ItemStack stack, int width, int height) {
        this.stack = stack;
        this.font = Minecraft.m_91087_().f_91062_;
        this.width = width;
        this.height = height;
    }

    public boolean isRenderingCount() {
        return this.renderCount;
    }

    public void renderCount(boolean TorF) {
        this.renderCount = TorF;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void render(@Nullable GuiGraphics pose, ItemRenderer renderer, int x, int y, int width, int height) {
        if (this.stack == null) {
            return;
        }
        this.renderItem(renderer, this.stack, x, y, width, height);
        if (this.renderCount && this.stack.m_41753_() && this.stack.m_41613_() > 1 && pose != null) {
            String count = String.valueOf(this.stack.m_41613_());
            int w = this.font.m_92895_(count);
            Objects.requireNonNull(this.font);
            pose.m_280488_(this.font, count, x + width - w, y + height - 9, 0xFFFFFF);
        }
    }

    public void render(@Nullable GuiGraphics pose, ItemRenderer renderer, int x, int y) {
        this.render(pose, renderer, x, y, this.width, this.height);
    }

    public void renderCentered(@Nullable GuiGraphics pose, ItemRenderer renderer, int centerX, int centerY, int width, int height) {
        this.render(pose, renderer, centerX - width / 2, centerY - height / 2);
    }

    public void renderCentered(@Nullable GuiGraphics pose, ItemRenderer renderer, int centerX, int centerY) {
        this.renderCentered(pose, renderer, centerX, centerY, this.width, this.height);
    }

    private void renderItem(ItemRenderer renderer, ItemStack item, int x, int y, int width, int height) {
        BakedModel model = renderer.m_174264_(item, (Level)null, (LivingEntity)null, 0);
        this.renderGuiItem(renderer, item, x, y, width, height, model);
    }

    protected void renderGuiItem(ItemRenderer renderer, ItemStack pStack, int x, int y, int width, int height, BakedModel pBakedModel) {
        boolean flag;
        TextureManager manager = Minecraft.m_91087_().f_90987_;
        manager.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_252880_((float)x, (float)y, 0.0f);
        posestack.m_85837_((double)((float)width / 2.0f), (double)((float)height / 2.0f), 0.0);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_((float)width, (float)height, 1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !pBakedModel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        renderer.m_115143_(pStack, ItemDisplayContext.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, pBakedModel);
        multibuffersource$buffersource.m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }
}

