/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.render.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nonnull;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.client.render.PoseContext;
import kasuga.lib.core.client.render.RendererUtil;
import kasuga.lib.core.client.render.SimpleColor;
import kasuga.lib.registrations.client.ModelReg;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class SimpleModel {
    public final String key;
    RandomSource random;
    BakedModel model = null;
    SimpleColor color;
    PoseContext context = PoseContext.of();
    RenderTypeBuilder builder = null;
    RenderType cacheType = null;
    boolean useParentPose = false;
    boolean shouldRender = true;

    public SimpleModel(@Nonnull String key, BakedModel model) {
        this.key = key;
        this.model = model;
        this.random = KasugaLib.STACKS.random();
        this.color = SimpleColor.fromRGBInt(0xFFFFFF);
    }

    public SimpleModel(@Nonnull ModelReg reg) {
        this(reg.registrationKey, reg.getModel().model);
    }

    public void copyModelFrom(SimpleModel model) {
        this.model = model.model;
    }

    public void renderType(RenderTypeBuilder builder) {
        this.builder = builder;
    }

    public void addAction(PoseContext.Action act) {
        this.context.addAct(act);
    }

    public void translate(double x, double y, double z) {
        this.context.translate(x, y, z);
    }

    public void rotateY(float yRot) {
        this.context.rotateY(yRot);
    }

    public void rotateZ(float yRot) {
        this.context.rotateZ(yRot);
    }

    public void rotateX(float xRot) {
        this.context.rotateX(xRot);
    }

    public void scale(float x, float y, float z) {
        this.context.scale(x, y, z);
    }

    public void lockMovement() {
        this.context.setLock(true);
    }

    public void unlockMovement() {
        this.context.setLock(false);
    }

    public boolean isMovementLocked() {
        return this.context.isLocked();
    }

    public void shouldAutoClearMovement(boolean flag) {
        this.context.setAutoClear(flag);
    }

    public boolean isAutoClearMovements() {
        return this.context.isAutoClear();
    }

    public void setColor(int r, int g, int b, int a) {
        this.color = SimpleColor.fromRGBA(r, g, b, a);
    }

    public void setColor(SimpleColor color) {
        this.color = color;
    }

    public SimpleColor getColor() {
        return this.color;
    }

    public void turnToPlayer(@Nullable Player player, Vec3 position) {
        this.rotateY((float)RendererUtil.getVecHorizontalAngles(position, player == null ? position : player.m_146892_()));
    }

    public boolean isUsingParentPose() {
        return this.useParentPose;
    }

    public void shouldUseParentPose(boolean flag) {
        this.useParentPose = flag;
    }

    public boolean isRendering() {
        return this.shouldRender;
    }

    public void shouldRender(boolean flag) {
        this.shouldRender = flag;
    }

    public void render(PoseStack pose, MultiBufferSource source, float x, float y, float z, int light, int overlay) {
        if (!this.shouldRender) {
            return;
        }
        if (this.builder == null) {
            return;
        }
        if (this.cacheType == null) {
            this.cacheType = this.builder.build();
        }
        boolean shouldPush = pose.m_85851_();
        Matrix4f lastMatrix = null;
        if (shouldPush) {
            lastMatrix = pose.m_85850_().m_252922_();
            pose.m_85849_();
        }
        pose.m_85836_();
        if (this.useParentPose && lastMatrix != null) {
            pose.m_252931_(lastMatrix);
        }
        this.context.apply(pose);
        pose.m_252880_(x, y, z);
        this.renderModel(pose, source.m_6299_(this.cacheType), this.transform(this.random, this.cacheType), this.color, light, overlay);
        pose.m_85849_();
        if (shouldPush) {
            pose.m_85836_();
            pose.m_252931_(lastMatrix);
        }
    }

    List<BakedQuad> transform(RandomSource random, RenderType type) {
        if (this.model == null) {
            return List.of();
        }
        return this.model.getQuads(null, null, random, ModelData.EMPTY, type);
    }

    void renderModel(PoseStack pose, VertexConsumer consumer, List<BakedQuad> quads, SimpleColor color, int light, int overlay) {
        for (BakedQuad bakedquad : quads) {
            consumer.m_85987_(pose.m_85850_(), bakedquad, color.getfR(), color.getfG(), color.getfB(), light, overlay);
        }
    }

    public SimpleModel clone() {
        return new SimpleModel(String.valueOf(this.key.toCharArray()), this.model);
    }

    public BakedModel getModel() {
        return this.model;
    }

    public static interface RenderTypeBuilder {
        public RenderType build();
    }
}

