/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.javascript.module;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import kasuga.lib.core.javascript.module.JavascriptModule;
import kasuga.lib.core.javascript.module.ModuleLoader;
import kasuga.lib.core.util.SortedArrayList;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.core.util.data_type.PrioritizedItem;

public class RegistryLoader
implements ModuleLoader {
    Set<ModuleLoader> registeredLoaders = new HashSet<ModuleLoader>();
    SortedArrayList<PrioritizedItem<ModuleLoader>> list = new SortedArrayList();
    RegistryLoader parent;

    public RegistryLoader() {
        this.parent = null;
    }

    public RegistryLoader(RegistryLoader parent) {
        this.parent = parent;
    }

    public void register(ModuleLoader loader) {
        this.register(loader, 0);
    }

    public void register(ModuleLoader loader, Integer priority) {
        this.list.add(PrioritizedItem.of(loader, priority));
        this.registeredLoaders.add(loader);
    }

    @Override
    public Optional<JavascriptModule> load(JavascriptModule source, String name) {
        for (Pair pair : this.list) {
            Optional<JavascriptModule> module = ((ModuleLoader)pair.getFirst()).load(source, name);
            if (!module.isPresent()) continue;
            return module;
        }
        if (this.parent != null) {
            return this.parent.load(source, name);
        }
        return Optional.empty();
    }
}

