/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.example_env.entity;

import java.util.List;
import kasuga.lib.core.client.animation.data.Animation;
import kasuga.lib.core.client.render.RendererUtil;
import kasuga.lib.core.client.render.model.MultiPartModel;
import kasuga.lib.example_env.AllExampleElements;
import kasuga.lib.example_env.entity.DoorControl;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class WuLingEntity
extends LivingEntity {
    public DoorControl doorControl = new DoorControl();
    public final Animation animation;

    public WuLingEntity(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        Animation animation = this.animation = this.m_9236_().f_46443_ ? AllExampleElements.test_anim.getInstance() : null;
        if (this.m_9236_().f_46443_) {
            MultiPartModel model = (MultiPartModel)AllExampleElements.wuLingVans.getModel().clone();
            model.renderType(RenderType::m_110451_);
            model.applyParentRenderTypeForAllBones();
            this.animation.loadModel(model);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 100.0);
    }

    public Iterable<ItemStack> m_6168_() {
        return List.of();
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.clientTick();
        } else {
            this.serverTick();
        }
    }

    public void m_6478_(MoverType pType, Vec3 pPos) {
        super.m_6478_(pType, pPos);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        CompoundTag door = new CompoundTag();
        this.doorControl.write(door);
        pCompound.m_128365_("door", (Tag)door);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("door")) {
            this.doorControl.read(pCompound.m_128469_("door"));
        }
    }

    public void serverTick() {
    }

    public void clientTick() {
    }

    public void m_6123_(Player pPlayer) {
        super.m_6123_(pPlayer);
    }

    public InteractionResult m_7111_(Player pPlayer, Vec3 pVec, InteractionHand pHand) {
        float carAngle;
        Vec3 position = this.m_20182_();
        Vec3 playerPos = pPlayer.m_20182_();
        float angle = (float)RendererUtil.getVecHorizontalAngles(playerPos, position);
        float relativeAngle = angle - (carAngle = this.m_146908_());
        if (relativeAngle > -10.0f && relativeAngle < 20.0f) {
            this.doorControl.setMidBack(!this.doorControl.isMidBack());
        } else if (relativeAngle > 20.0f && relativeAngle < 90.0f) {
            this.doorControl.setRightBack(!this.doorControl.isRightBack());
        } else if (relativeAngle > 90.0f && relativeAngle < 140.0f) {
            this.doorControl.setRightFront(!this.doorControl.isRightFront());
        } else if (relativeAngle > -90.0f && relativeAngle < -10.0f) {
            this.doorControl.setLeftBack(!this.doorControl.isLeftBack());
        } else if (relativeAngle > 220.0f && relativeAngle < 270.0f) {
            this.doorControl.setLeftFront(!this.doorControl.isLeftFront());
        }
        return InteractionResult.SUCCESS;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void actAnimation() {
        this.animation.assign("left_front", this.doorControl.isLeftFront() ? 1.0f : 0.0f);
        this.animation.assign("left_back", this.doorControl.isLeftBack() ? 1.0f : 0.0f);
        this.animation.assign("right_front", this.doorControl.isRightFront() ? 1.0f : 0.0f);
        this.animation.assign("right_back", this.doorControl.isRightBack() ? 1.0f : 0.0f);
        this.animation.assign("mid_back", this.doorControl.isMidBack() ? 1.0f : 0.0f);
    }

    public void onDrive(Player driver) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }
}

