/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.core.annos.Optional;
import kasuga.lib.core.base.CustomBlockRenderer;
import kasuga.lib.registrations.BlockEntityRendererBuilder;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.common.BlockEntityReg;
import kasuga.lib.registrations.common.CreativeTabReg;
import kasuga.lib.registrations.common.ItemReg;
import kasuga.lib.registrations.common.MenuReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.RegistryObject;

public class BlockReg<T extends Block>
extends Reg {
    private MapColor color = MapColor.f_283808_;
    public BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
    private BlockBuilder<T> builder;
    private ItemReg<?> itemReg = null;
    private BlockEntityReg<? extends BlockEntity> blockEntityReg = null;
    private MenuReg<?, ?> menuReg = null;
    private final ArrayList<PropertyIdentifier> identifier;
    private RegistryObject<T> registryObject;
    private final List<TagKey<?>> tags = new ArrayList();
    boolean registerItem = false;
    boolean registerBe = false;
    boolean registerMenu = false;
    private BlockRendererBuilder<T> rendererBuilder = null;

    public BlockReg(String registrationKey) {
        super(registrationKey);
        this.identifier = new ArrayList();
    }

    public BlockReg<T> blockType(BlockBuilder<T> builder) {
        this.builder = builder;
        return this;
    }

    @Optional
    public BlockReg<T> defaultBlockItem(ResourceLocation modelLocation) {
        this.itemReg = ItemReg.defaultBlockItem(this, modelLocation);
        this.registerItem = true;
        return this;
    }

    @Optional
    public BlockReg<T> defaultBlockItem() {
        this.itemReg = ItemReg.defaultBlockItem(this);
        this.registerItem = true;
        return this;
    }

    public BlockReg<T> materialColor(MapColor color) {
        this.color = color;
        return this;
    }

    @Optional
    public BlockReg<T> addProperty(PropertyIdentifier identifier) {
        this.identifier.add(identifier);
        return this;
    }

    @Optional
    public BlockReg<T> withSound(SoundType sound) {
        this.properties.m_60918_(sound);
        return this;
    }

    public BlockReg<T> withBlockRenderer(BlockRendererBuilder<T> builder) {
        this.rendererBuilder = builder;
        return this;
    }

    @Optional
    public <R extends BlockEntity> BlockReg<T> withBlockEntity(String beRegistrationKey, BlockEntityType.BlockEntitySupplier<R> supplier) {
        this.blockEntityReg = new BlockEntityReg(beRegistrationKey).blockEntityType(supplier).addBlock(() -> (Block)this.registryObject.get());
        this.registerBe = true;
        return this;
    }

    @Optional
    public BlockReg<T> withBlockEntity(BlockEntityReg<? extends BlockEntity> blockEntityReg) {
        this.blockEntityReg = blockEntityReg.addBlock(() -> (Block)this.registryObject.get());
        this.registerBe = false;
        return this;
    }

    @Optional
    public BlockReg<T> withBlockEntityRenderer(Supplier<BlockEntityRendererBuilder> builder) {
        if (this.blockEntityReg == null) {
            this.crashOnNotPresent(BlockEntityReg.class, "BlockEntityReg", "withBlockEntityRenderer");
            return this;
        }
        this.blockEntityReg.withRenderer(builder::get);
        return this;
    }

    @Optional
    public <F extends AbstractContainerMenu, U extends Screen> BlockReg<T> withMenu(String registrationKey, IContainerFactory<?> menu, MenuReg.ScreenInvoker<U> screen) {
        this.menuReg = new MenuReg(registrationKey).withMenuAndScreen(menu, screen);
        this.registerMenu = true;
        return this;
    }

    @Optional
    public BlockReg<T> withMenu(MenuReg<?, ?> menuReg) {
        this.menuReg = menuReg;
        this.registerMenu = false;
        return this;
    }

    @Optional
    public <F extends AbstractContainerMenu, U extends Screen> BlockReg<T> withItemMenu(String registrationKey, IContainerFactory<?> menu, MenuReg.ScreenInvoker<U> screen) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "withItemMenu");
            return this;
        }
        this.itemReg.withMenu(registrationKey, menu, screen);
        return this;
    }

    @Optional
    public BlockReg<T> withItemMenu(MenuReg<?, ?> menuReg) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "withItemMenu");
            return this;
        }
        this.itemReg.withMenu(menuReg);
        return this;
    }

    @Optional
    public <R extends Item> BlockReg<T> withItem(ItemReg.ItemBuilder<R> builder, ResourceLocation itemModelLocation) {
        this.itemReg = new ItemReg(this.registrationKey, itemModelLocation);
        this.itemReg.itemType(builder);
        this.registerItem = true;
        return this;
    }

    @Optional
    public BlockReg<T> shouldCustomRenderItem(boolean flag) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "shouldCustomRenderItem");
            return this;
        }
        this.itemReg.shouldCustomRender(flag);
        return this;
    }

    @Optional
    public BlockReg<T> itemProperty(ItemReg.PropertyIdentifier identifier) {
        if (this.itemReg == null) {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "itemProperty");
        }
        this.itemReg = this.itemReg.withProperty(identifier);
        return this;
    }

    @Optional
    public BlockReg<T> tabTo(CreativeTabReg reg) {
        if (this.itemReg != null) {
            this.itemReg.tab(reg);
        } else {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "tabTo");
        }
        return this;
    }

    @Optional
    public BlockReg<T> stackSize(int size) {
        if (this.itemReg != null) {
            this.itemReg.stackTo(size);
        } else {
            this.crashOnNotPresent(ItemReg.class, "itemReg", "stackSize");
        }
        return this;
    }

    @Optional
    public BlockReg<T> withTags(TagKey<Block> tag) {
        this.tags.add(tag);
        return this;
    }

    @Override
    @Mandatory
    public BlockReg<T> submit(SimpleRegistry registry) {
        this.initProperties();
        if (this.builder == null) {
            this.crashOnNotPresent(Block.class, "blockType", "submit");
        }
        this.registryObject = registry.block().register(this.registrationKey, () -> this.builder.build(this.properties));
        if (this.itemReg != null && this.registerItem) {
            this.itemReg = this.itemReg.submit(registry);
        }
        if (this.blockEntityReg != null && this.registerBe) {
            if (registry.hasBeCache(this.toString())) {
                registry.getBeCached(this.toString()).withBlocks(() -> (Block)this.registryObject.get());
            } else {
                registry.cacheBeIn(this.blockEntityReg);
            }
        }
        if (this.menuReg != null && this.registerMenu && !registry.hasMenuCache(this.toString())) {
            registry.cacheMenuIn(this.menuReg);
        }
        if (this.rendererBuilder != null) {
            registry.cacheBlockRendererIn(this, this.rendererBuilder);
        }
        return this;
    }

    public ItemReg<?> getItemReg() {
        return this.itemReg;
    }

    public MenuReg<?, ?> getMenuReg() {
        return this.menuReg;
    }

    public BlockEntityReg<?> getBlockEntityReg() {
        return this.blockEntityReg;
    }

    public T instance() {
        return (T)(this.registryObject == null ? null : (Block)this.registryObject.get());
    }

    public Item itemInstance() {
        return this.itemReg != null ? (Item)this.itemReg.getItem() : null;
    }

    public RegistryObject<T> getRegistryObject() {
        return this.registryObject;
    }

    public T getBlock() {
        return (T)(this.registryObject == null ? null : (Block)this.registryObject.get());
    }

    @Override
    public String getIdentifier() {
        return "block";
    }

    @Inner
    public void initProperties() {
        this.properties = BlockBehaviour.Properties.m_284310_().m_284180_(this.color);
        this.identifier.forEach(i -> i.apply(this.properties));
    }

    public static interface BlockRendererBuilder<T extends Block> {
        public Supplier<CustomBlockRenderer> build(Supplier<T> var1);
    }

    public static interface BlockBuilder<T extends Block> {
        public T build(BlockBehaviour.Properties var1);
    }

    public static interface PropertyIdentifier {
        public void apply(BlockBehaviour.Properties var1);
    }
}

