/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.registrations.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kasuga.lib.core.annos.Inner;
import kasuga.lib.core.annos.Mandatory;
import kasuga.lib.core.annos.Optional;
import kasuga.lib.registrations.BlockEntityRendererBuilder;
import kasuga.lib.registrations.Reg;
import kasuga.lib.registrations.common.BlockEntityReg;
import kasuga.lib.registrations.common.BlockReg;
import kasuga.lib.registrations.common.MenuReg;
import kasuga.lib.registrations.registry.SimpleRegistry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.RegistryObject;

public class FluidBlockReg<T extends LiquidBlock>
extends Reg {
    private MapColor color = MapColor.f_283808_;
    public BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
    private FluidBlockBuilder<T> builder;
    private BlockEntityReg<? extends BlockEntity> blockEntityReg = null;
    private MenuReg<?, ?> menuReg = null;
    private BlockReg.PropertyIdentifier identifier;
    private Supplier<? extends ForgeFlowingFluid> fluid;
    private RegistryObject<T> registryObject;
    private final List<TagKey<?>> tags = new ArrayList();
    boolean registerBe = false;
    boolean registerMenu = false;
    BlockReg.BlockRendererBuilder<T> rendererBuilder;

    public FluidBlockReg(String registrationKey) {
        super(registrationKey);
    }

    public FluidBlockReg<T> fluid(Supplier<? extends ForgeFlowingFluid> fluid) {
        this.fluid = fluid;
        return this;
    }

    @Mandatory
    public FluidBlockReg<T> blockType(FluidBlockBuilder<? extends LiquidBlock> builder) {
        this.builder = builder;
        return this;
    }

    public FluidBlockReg<T> MapColor(MapColor color) {
        this.color = color;
        return this;
    }

    @Optional
    public FluidBlockReg<T> addProperty(BlockReg.PropertyIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    @Optional
    public FluidBlockReg<T> withSound(SoundType sound) {
        this.properties.m_60918_(sound);
        return this;
    }

    @Optional
    public <R extends BlockEntity> FluidBlockReg<T> withBlockEntity(String beRegistrationKey, BlockEntityType.BlockEntitySupplier<R> supplier) {
        this.blockEntityReg = new BlockEntityReg(beRegistrationKey).blockEntityType(supplier).addBlock(() -> (Block)this.registryObject.get());
        this.registerBe = true;
        return this;
    }

    @Optional
    public FluidBlockReg<T> withBlockEntity(BlockEntityReg<? extends BlockEntity> blockEntityReg) {
        this.blockEntityReg = blockEntityReg.addBlock(() -> (Block)this.registryObject.get());
        this.registerBe = false;
        return this;
    }

    @Optional
    public FluidBlockReg<T> withBlockEntityRenderer(Supplier<BlockEntityRendererBuilder> builder) {
        if (this.blockEntityReg == null) {
            this.crashOnNotPresent(BlockEntityReg.class, "blockEntityReg", "withBlockEntityRenderer");
            return this;
        }
        this.blockEntityReg.withRenderer(builder::get);
        return this;
    }

    public FluidBlockReg<T> withBlockRenderer(BlockReg.BlockRendererBuilder<T> builder) {
        this.rendererBuilder = builder;
        return this;
    }

    @Optional
    public <F extends AbstractContainerMenu, U extends Screen> FluidBlockReg<T> withMenu(String registrationKey, IContainerFactory<?> menu, MenuReg.ScreenInvoker<U> screen) {
        this.menuReg = new MenuReg(registrationKey).withMenuAndScreen(menu, screen);
        this.registerMenu = true;
        return this;
    }

    @Optional
    public FluidBlockReg<T> withMenu(MenuReg<?, ?> menuReg) {
        this.menuReg = menuReg;
        this.registerMenu = false;
        return this;
    }

    @Optional
    public FluidBlockReg<T> withTags(TagKey<Block> tag) {
        this.tags.add(tag);
        return this;
    }

    @Override
    @Mandatory
    public FluidBlockReg<T> submit(SimpleRegistry registry) {
        this.initProperties();
        if (this.builder == null) {
            this.crashOnNotPresent(FluidBlockBuilder.class, "fluid", "submit");
        }
        this.registryObject = registry.block().register(this.registrationKey, () -> this.builder.build(this.fluid, this.properties));
        if (this.blockEntityReg != null && this.registerBe) {
            if (registry.hasBeCache(this.toString())) {
                registry.getBeCached(this.toString()).withBlocks(() -> (Block)this.registryObject.get());
            } else {
                registry.cacheBeIn(this.blockEntityReg);
            }
        }
        if (this.menuReg != null && this.registerMenu && !registry.hasMenuCache(this.toString())) {
            registry.cacheMenuIn(this.menuReg);
        }
        if (this.rendererBuilder != null) {
            registry.cacheBlockRendererIn(this, this.rendererBuilder);
        }
        return this;
    }

    public MenuReg<?, ?> getMenuReg() {
        return this.menuReg;
    }

    public BlockEntityReg<?> getBlockEntityReg() {
        return this.blockEntityReg;
    }

    @Inner
    private void initProperties() {
        this.properties = BlockBehaviour.Properties.m_284310_().m_284180_(this.color);
        if (this.identifier != null) {
            this.identifier.apply(this.properties);
        }
    }

    public RegistryObject<T> getRegistryObject() {
        return this.registryObject;
    }

    public T getBlock() {
        return (T)(this.registryObject == null ? null : (LiquidBlock)this.registryObject.get());
    }

    @Override
    public String getIdentifier() {
        return "fluid_block";
    }

    public T instance() {
        return (T)(this.registryObject == null ? null : (LiquidBlock)this.registryObject.get());
    }

    public static interface FluidBlockBuilder<T extends LiquidBlock> {
        public T build(Supplier<? extends ForgeFlowingFluid> var1, BlockBehaviour.Properties var2);
    }
}

