/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access;

import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Executed;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.StandardTags;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.ConditionProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.ReadNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.RepeatableNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.JSGuardDisconnectedArgumentReadNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.ReadElementNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.instrumentation.NodeObjectDescriptor;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSAbstractArgumentsArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSArgumentsArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class JSGuardDisconnectedArgumentRead
extends JavaScriptNode
implements RepeatableNode,
ReadNode {
    private final int argumentIndex;
    @Node.Child
    @Executed
    JavaScriptNode argumentsArrayNode;
    @Node.Child
    private ReadElementNode readElementNode;
    private final TruffleString name;

    JSGuardDisconnectedArgumentRead(int index, ReadElementNode readElementNode, JavaScriptNode argumentsArray, TruffleString name) {
        this.argumentIndex = index;
        this.argumentsArrayNode = argumentsArray;
        this.readElementNode = readElementNode;
        this.name = name;
    }

    public static JSGuardDisconnectedArgumentRead create(int index, ReadElementNode readElementNode, JavaScriptNode argumentsArray, TruffleString name) {
        return JSGuardDisconnectedArgumentReadNodeGen.create(index, readElementNode, argumentsArray, name);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ReadVariableTag.class || tag == StandardTags.ReadVariableTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object getNodeObject() {
        NodeObjectDescriptor descriptor = JSTags.createNodeObjectDescriptor("name", this.name);
        descriptor.addProperty("readVariableName", (Object)this.name);
        return descriptor;
    }

    @Specialization(guards={"!isArgumentsDisconnected(argumentsArray)"})
    public Object doObject(JSArgumentsObject argumentsArray, @Cached(value="createBinaryProfile()") @Cached.Shared(value="unconnected") ConditionProfile unconnected) {
        assert (JSArgumentsArray.isJSArgumentsObject(argumentsArray));
        if (unconnected.profile(this.argumentIndex >= JSAbstractArgumentsArray.getConnectedArgumentCount(argumentsArray))) {
            return Undefined.instance;
        }
        return this.readElementNode.executeWithTargetAndIndex((Object)argumentsArray, this.argumentIndex);
    }

    public final int getIndex() {
        return this.argumentIndex;
    }

    @Specialization(guards={"isArgumentsDisconnected(argumentsArray)"})
    public Object doObjectDisconnected(JSArgumentsObject argumentsArray, @Cached(value="createBinaryProfile()") ConditionProfile wasDisconnected, @Cached(value="createBinaryProfile()") @Cached.Shared(value="unconnected") ConditionProfile unconnected) {
        assert (JSArgumentsArray.isJSArgumentsObject(argumentsArray));
        if (wasDisconnected.profile(JSAbstractArgumentsArray.wasIndexDisconnected(argumentsArray, this.argumentIndex))) {
            return JSAbstractArgumentsArray.getDisconnectedIndexValue(argumentsArray, this.argumentIndex);
        }
        if (unconnected.profile(this.argumentIndex >= JSAbstractArgumentsArray.getConnectedArgumentCount(argumentsArray))) {
            return Undefined.instance;
        }
        return this.readElementNode.executeWithTargetAndIndex((Object)argumentsArray, this.argumentIndex);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSGuardDisconnectedArgumentReadNodeGen.create(this.argumentIndex, JSGuardDisconnectedArgumentRead.cloneUninitialized(this.readElementNode, materializedTags), JSGuardDisconnectedArgumentRead.cloneUninitialized(this.argumentsArrayNode, materializedTags), this.name);
    }
}

