/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary;

import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.NodeInfo;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.BranchProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.ConditionProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.Truncatable;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.JSConstantNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary.JSUnsignedRightShiftConstantNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.binary.JSUnsignedRightShiftNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToUInt32Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.BigInt;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.SafeInteger;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;

@NodeInfo(shortName=">>>")
public abstract class JSUnsignedRightShiftNode
extends JSBinaryNode {
    @Node.Child
    private JSToUInt32Node toUInt32Node;

    protected JSUnsignedRightShiftNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JavaScriptNode create(JavaScriptNode left, JavaScriptNode right) {
        Truncatable.truncate(left);
        Truncatable.truncate(right);
        if (right instanceof JSConstantNode.JSConstantIntegerNode) {
            return JSUnsignedRightShiftConstantNode.create(left, right);
        }
        return JSUnsignedRightShiftNodeGen.create(left, right);
    }

    static JSUnsignedRightShiftNode create() {
        return JSUnsignedRightShiftNodeGen.create(null, null);
    }

    protected final Number executeNumber(Object a, Object b) {
        return (Number)this.execute(a, b);
    }

    public abstract Object execute(Object var1, Object var2);

    protected static boolean rvalZero(int b) {
        return (b & 0x1F) == 0;
    }

    @Specialization(guards={"rvalZero(b)", "a >= 0"})
    protected int doIntegerFast(int a, int b) {
        return a;
    }

    @Specialization(guards={"a >= 0"})
    protected int doInteger(int a, int b) {
        return a >>> b;
    }

    @Specialization(guards={"!rvalZero(b)"})
    protected int doIntegerNegative(int a, int b) {
        return a >>> b;
    }

    @Specialization(guards={"rvalZero(b)"})
    protected double doDoubleZero(double a, int b) {
        return this.toUInt32(a);
    }

    @Specialization(guards={"!rvalZero(b)"})
    protected Number doDouble(double a, int b, @Cached(value="createBinaryProfile()") ConditionProfile returnType) {
        long lnum = this.toUInt32(a);
        int shiftCount = b & 0x1F;
        if (returnType.profile(lnum >= Integer.MAX_VALUE || lnum <= Integer.MIN_VALUE)) {
            return (double)(lnum >>> shiftCount);
        }
        return (int)(lnum >>> shiftCount);
    }

    @Specialization
    protected Number doIntDouble(int a, double b, @Cached(value="create()") JSToUInt32Node rvalToUint32Node, @Cached(value="createBinaryProfile()") ConditionProfile returnType) {
        long lnum = this.toUInt32(a);
        int shiftCount = (int)rvalToUint32Node.executeLong(b) & 0x1F;
        if (returnType.profile(lnum >= Integer.MAX_VALUE || lnum <= Integer.MIN_VALUE)) {
            return (double)(lnum >>> shiftCount);
        }
        return (int)(lnum >>> shiftCount);
    }

    @Specialization
    protected double doDoubleDouble(double a, double b) {
        return this.toUInt32(a) >>> ((int)this.toUInt32(b) & 0x1F);
    }

    @Specialization
    protected Number doBigInt(BigInt a, BigInt b) {
        throw Errors.createTypeError("BigInts have no unsigned right shift, use >> instead");
    }

    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected Object doOverloaded(Object a, Object b, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a, b);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.ANGLE_BRACKET_CLOSE_3;
    }

    @Specialization(guards={"!hasOverloadedOperators(lval)", "!hasOverloadedOperators(rval)", "!isHandled(lval, rval)"})
    protected Number doGeneric(Object lval, Object rval, @Cached(value="create()") JSToNumericNode lvalToNumericNode, @Cached(value="create()") JSToNumericNode rvalToNumericNode, @Cached(value="create()") JSUnsignedRightShiftNode innerShiftNode, @Cached(value="create()") BranchProfile mixedNumericTypes) {
        Object lnum = lvalToNumericNode.execute(lval);
        Object rnum = rvalToNumericNode.execute(rval);
        this.ensureBothSameNumericType(lnum, rnum, mixedNumericTypes);
        return innerShiftNode.executeNumber(lnum, rnum);
    }

    private long toUInt32(Object target) {
        if (this.toUInt32Node == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toUInt32Node = this.insert(JSToUInt32Node.create());
        }
        return this.toUInt32Node.executeLong(target);
    }

    protected static boolean isHandled(Object lval, Object rval) {
        return !(!(lval instanceof Integer) && !(lval instanceof Double) && !(lval instanceof SafeInteger) || !(rval instanceof Integer) && !(rval instanceof Double) && !(rval instanceof SafeInteger));
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSUnsignedRightShiftNodeGen.create(JSUnsignedRightShiftNode.cloneUninitialized(this.getLeft(), materializedTags), JSUnsignedRightShiftNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

