/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToBigIntNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.BigInt;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSErrorType;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Strings;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Symbol;

public abstract class JSToBigIntNode
extends JavaScriptBaseNode {
    public abstract Object execute(Object var1);

    public final BigInt executeBigInteger(Object value) {
        return (BigInt)this.execute(value);
    }

    public static JSToBigIntNode create() {
        return JSToBigIntNodeGen.create();
    }

    @Specialization
    protected Object doIt(Object value, @Cached(value="createHintNumber()") JSToPrimitiveNode toPrimitiveNode, @Cached(value="create()") JSToBigIntInnerConversionNode innerConversionNode) {
        return innerConversionNode.execute(toPrimitiveNode.execute(value));
    }

    public static abstract class JSToBigIntInnerConversionNode
    extends JavaScriptBaseNode {
        public static JSToBigIntInnerConversionNode create() {
            return JSToBigIntNodeGen.JSToBigIntInnerConversionNodeGen.create();
        }

        public abstract Object execute(Object var1);

        public final BigInt executeBigInteger(Object value) {
            return (BigInt)this.execute(value);
        }

        @Specialization
        protected static BigInt doBoolean(boolean value) {
            return value ? BigInt.ONE : BigInt.ZERO;
        }

        @Specialization
        protected static BigInt doBigInt(BigInt value) {
            return value;
        }

        @Specialization(guards={"isNumber(value)"})
        protected static BigInt doDouble(Object value) {
            throw Errors.createErrorCanNotConvertToBigInt(JSErrorType.TypeError, value);
        }

        @Specialization
        protected static BigInt doSymbol(Symbol value) {
            throw Errors.createErrorCanNotConvertToBigInt(JSErrorType.TypeError, value);
        }

        @Specialization(guards={"isNullOrUndefined(value)"})
        protected static BigInt doNullOrUndefined(Object value) {
            throw Errors.createErrorCanNotConvertToBigInt(JSErrorType.TypeError, value);
        }

        @Specialization
        protected static BigInt doString(TruffleString value) {
            try {
                return Strings.parseBigInt(value);
            }
            catch (NumberFormatException e) {
                throw Errors.createErrorCanNotConvertToBigInt(JSErrorType.SyntaxError, value);
            }
        }
    }
}

