/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.ImportStatic;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToIntegerAsLongNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.BigInt;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Errors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSRuntime;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.SafeInteger;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.Symbol;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObject;

@ImportStatic(value={Double.class})
public abstract class JSToIntegerAsLongNode
extends JavaScriptBaseNode {
    public static JSToIntegerAsLongNode create() {
        return JSToIntegerAsLongNodeGen.create();
    }

    public abstract long executeLong(Object var1);

    @Specialization
    protected static long doInteger(int value) {
        return value;
    }

    @Specialization
    protected static long doBoolean(boolean value) {
        return JSRuntime.booleanToNumber(value);
    }

    @Specialization
    protected static long doSafeInteger(SafeInteger value) {
        return value.longValue();
    }

    @Specialization(guards={"!isInfinite(value)"})
    protected static long doDouble(double value) {
        return (long)value;
    }

    @Specialization(guards={"isInfinite(value)"})
    protected static long doDoubleInfinite(double value) {
        return value > 0.0 ? Long.MAX_VALUE : Long.MIN_VALUE;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static long doUndefined(Object value) {
        return 0L;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static long doNull(Object value) {
        return 0L;
    }

    @Specialization
    protected final long doSymbol(Symbol value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value", this);
    }

    @Specialization
    protected final long doBigInt(BigInt value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a BigInt value", this);
    }

    @Specialization
    protected long doString(TruffleString value, @Cached(value="create()") JSToIntegerAsLongNode nestedToIntegerNode, @Cached(value="create()") JSStringToNumberNode stringToNumberNode) {
        return nestedToIntegerNode.executeLong(stringToNumberNode.executeString(value));
    }

    @Specialization
    protected long doJSObject(JSObject value, @Cached(value="create()") JSToNumberNode toNumberNode) {
        return JSRuntime.toInteger(toNumberNode.executeNumber(value));
    }

    @Specialization(guards={"isForeignObject(value)"})
    protected long doForeignObject(Object value, @Cached(value="create()") JSToNumberNode toNumberNode) {
        return JSRuntime.toInteger(toNumberNode.executeNumber(value));
    }
}

