/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control;

import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CallTarget;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerAsserts;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.exception.AbstractTruffleException;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.MaterializedFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.VirtualFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.DirectCallNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.NodeCost;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.NodeInfo;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.source.SourceSection;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control.TryCatchNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.control.YieldException;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.promise.AsyncRootNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSArguments;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSFrameUtil;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JavaScriptRootNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Completion;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;

public final class TopLevelAwaitModuleBodyNode
extends JavaScriptNode {
    private final JSContext context;
    @CompilerDirectives.CompilationFinal
    private volatile CallTarget resumptionTarget;
    @Node.Child
    private JavaScriptNode moduleBodyNode;
    @Node.Child
    private JSWriteFrameSlotNode writeAsyncResult;
    @Node.Child
    private volatile DirectCallNode asyncCallNode;
    @Node.Child
    private JSWriteFrameSlotNode writeAsyncContextNode;

    private TopLevelAwaitModuleBodyNode(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode asyncResult, JSWriteFrameSlotNode writeAsyncContextNode) {
        this.context = context;
        this.moduleBodyNode = body;
        this.writeAsyncContextNode = writeAsyncContextNode;
        this.writeAsyncResult = asyncResult;
    }

    public static JavaScriptNode create(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode asyncContext, JSWriteFrameSlotNode writeAsyncContextNode) {
        return new TopLevelAwaitModuleBodyNode(context, body, asyncContext, writeAsyncContextNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object[] arguments = frame.getArguments();
        JSModuleRecord moduleRecord = (JSModuleRecord)JSArguments.getUserArgument(arguments, 0);
        MaterializedFrame moduleFrame = moduleRecord.getEnvironment() != null ? JSFrameUtil.castMaterializedFrame(moduleRecord.getEnvironment()) : frame.materialize();
        PromiseCapabilityRecord promiseCapability = JSArguments.getUserArgumentCount(arguments) >= 2 ? (PromiseCapabilityRecord)JSArguments.getUserArgument(arguments, 1) : null;
        this.ensureAsyncCallTargetInitialized();
        if (promiseCapability != null) {
            this.writeAsyncContextNode.executeWrite(moduleFrame, AsyncRootNode.createAsyncContext(this.resumptionTarget, promiseCapability, moduleFrame));
        }
        Object unusedInitialResult = null;
        this.asyncCallNode.call(JSArguments.createResumeArguments(moduleFrame, promiseCapability, Completion.Type.Normal, unusedInitialResult));
        if (promiseCapability == null) {
            return Undefined.instance;
        }
        return promiseCapability.getPromise();
    }

    private boolean asyncCallTargetInitializationRequired() {
        return this.resumptionTarget == null || this.asyncCallNode == null;
    }

    private void ensureAsyncCallTargetInitialized() {
        if (this.asyncCallTargetInitializationRequired()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initializeAsyncCallTarget();
        }
    }

    private void initializeAsyncCallTarget() {
        CompilerAsserts.neverPartOfCompilation();
        this.atomic(() -> {
            if (this.asyncCallTargetInitializationRequired()) {
                TopLevelAwaitModuleRootNode asyncRootNode = new TopLevelAwaitModuleRootNode(this.context, this.moduleBodyNode, this.writeAsyncResult, this.getRootNode().getSourceSection(), "");
                this.resumptionTarget = asyncRootNode.getCallTarget();
                this.asyncCallNode = this.insert(DirectCallNode.create(this.resumptionTarget));
                this.moduleBodyNode = null;
                this.writeAsyncResult = null;
            }
        });
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return TopLevelAwaitModuleBodyNode.create(this.context, TopLevelAwaitModuleBodyNode.cloneUninitialized(this.moduleBodyNode, materializedTags), TopLevelAwaitModuleBodyNode.cloneUninitialized(this.writeAsyncResult, materializedTags), TopLevelAwaitModuleBodyNode.cloneUninitialized(this.writeAsyncContextNode, materializedTags));
    }

    @NodeInfo(cost=NodeCost.NONE, language="JavaScript")
    public static final class TopLevelAwaitModuleRootNode
    extends JavaScriptRootNode {
        private final JSContext context;
        private final String functionName;
        @Node.Child
        private JavaScriptNode functionBody;
        @Node.Child
        private JSFunctionCallNode callResolveNode;
        @Node.Child
        private JSFunctionCallNode callRejectNode;
        @Node.Child
        private JSWriteFrameSlotNode writeAsyncResult;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;

        TopLevelAwaitModuleRootNode(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode asyncResult, SourceSection functionSourceSection, String functionName) {
            super(context.getLanguage(), functionSourceSection, null);
            this.context = context;
            this.functionBody = body;
            this.callResolveNode = JSFunctionCallNode.createCall();
            this.functionName = functionName;
            this.writeAsyncResult = asyncResult;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] arguments = frame.getArguments();
            MaterializedFrame asyncFrame = JSArguments.getResumeExecutionContext(arguments);
            PromiseCapabilityRecord promiseCapability = (PromiseCapabilityRecord)JSArguments.getResumeGeneratorOrPromiseCapability(arguments);
            Completion resumptionValue = JSArguments.getResumeCompletion(arguments);
            this.writeAsyncResult.executeWrite(asyncFrame, resumptionValue);
            JSModuleRecord moduleRecord = (JSModuleRecord)JSArguments.getUserArgument(asyncFrame.getArguments(), 0);
            try {
                Object returnValue = this.functionBody.execute(asyncFrame);
                assert (promiseCapability != null);
                this.promiseCapabilityResolve(promiseCapability, returnValue);
            }
            catch (YieldException e) {
                assert (promiseCapability != null ? e.isAwait() : e.isYield());
                if (e.isYield()) {
                    moduleRecord.setEnvironment(JSFrameUtil.castMaterializedFrame(asyncFrame));
                } else assert (e.isAwait());
            }
            catch (AbstractTruffleException e) {
                if (promiseCapability != null) {
                    this.promiseCapabilityReject(promiseCapability, e);
                }
                throw e;
            }
            return Undefined.instance;
        }

        @Override
        public boolean isResumption() {
            return true;
        }

        @Override
        public String getName() {
            if (this.functionName != null && !this.functionName.isEmpty()) {
                return this.functionName;
            }
            return ":top-level-await-module";
        }

        private void promiseCapabilityResolve(PromiseCapabilityRecord promiseCapability, Object result) {
            this.callResolveNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getResolve(), result));
        }

        private void promiseCapabilityReject(PromiseCapabilityRecord promiseCapability, AbstractTruffleException e) {
            if (this.getErrorObjectNode == null || this.callRejectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getErrorObjectNode = this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
                this.callRejectNode = this.insert(JSFunctionCallNode.createCall());
            }
            Object result = this.getErrorObjectNode.execute(e);
            this.callRejectNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getReject(), result));
        }
    }
}

