/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.function;

import java.util.Set;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.frame.VirtualFrame;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.instrumentation.Tag;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.ConditionProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.IsObjectNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSFunction;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Null;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.Undefined;

public final class ConstructorResultNode
extends JavaScriptNode {
    @Node.Child
    private JavaScriptNode bodyNode;
    @Node.Child
    private JavaScriptNode thisNode;
    private final boolean derived;
    @Node.Child
    private IsObjectNode isObjectNode;
    private final ConditionProfile isObject = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isNotUndefined = ConditionProfile.createBinaryProfile();

    private ConstructorResultNode(boolean derived, JavaScriptNode bodyNode, JavaScriptNode thisNode) {
        this.bodyNode = bodyNode;
        this.derived = derived;
        this.thisNode = thisNode;
        this.isObjectNode = IsObjectNode.create();
    }

    public static JavaScriptNode createBase(JavaScriptNode bodyNode, JavaScriptNode thisNode) {
        return new ConstructorResultNode(false, bodyNode, thisNode);
    }

    public static JavaScriptNode createDerived(JavaScriptNode bodyNode, JavaScriptNode thisNode) {
        return new ConstructorResultNode(true, bodyNode, thisNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object result = this.bodyNode.execute(frame);
        if (this.isObject.profile(this.isObjectNode.executeBoolean(result))) {
            return result;
        }
        if (this.derived && this.isNotUndefined.profile(result != Undefined.instance)) {
            return Null.instance;
        }
        Object thisObject = this.thisNode.execute(frame);
        assert (thisObject != JSFunction.CONSTRUCT);
        return thisObject;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new ConstructorResultNode(this.derived, ConstructorResultNode.cloneUninitialized(this.bodyNode, materializedTags), ConstructorResultNode.cloneUninitialized(this.thisNode, materializedTags));
    }
}

