/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.temporal;

import kasuga.lib.vendor_modules.com.oracle.truffle.api.CompilerDirectives;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Cached;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.dsl.Specialization;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.nodes.Node;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.BranchProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.profiles.ConditionProfile;
import kasuga.lib.vendor_modules.com.oracle.truffle.api.strings.TruffleString;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.IsObjectNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.cast.JSToStringNode;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarNodeGen;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSContext;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendar;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.temporal.TemporalCalendar;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSObject;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.TemporalConstants;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.TemporalErrors;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalCalendarNode
extends JavaScriptBaseNode {
    private final ConditionProfile isObjectProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isCalendarProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile hasCalendarProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile hasCalendar2Profile = ConditionProfile.createBinaryProfile();
    private final BranchProfile parseBranch = BranchProfile.create();
    private final JSContext context;
    @Node.Child
    private PropertyGetNode getCalendarPropertyNode;

    protected ToTemporalCalendarNode(JSContext context) {
        this.context = context;
    }

    public static ToTemporalCalendarNode create(JSContext context) {
        return ToTemporalCalendarNodeGen.create(context);
    }

    public abstract JSDynamicObject executeDynamicObject(Object var1);

    @Specialization
    public JSDynamicObject toTemporalCalendar(Object itemParam, @Cached BranchProfile errorBranch, @Cached(value="create()") IsObjectNode isObjectNode, @Cached(value="create()") JSToStringNode toStringNode) {
        TruffleString identifier;
        Object item = itemParam;
        if (this.isObjectProfile.profile(isObjectNode.executeBoolean(item))) {
            JSDynamicObject itemObj = TemporalUtil.toJSDynamicObject(item, errorBranch);
            if (this.isCalendarProfile.profile(item instanceof TemporalCalendar)) {
                return ((TemporalCalendar)item).getCalendar();
            }
            if (this.hasCalendarProfile.profile(!JSObject.hasProperty(itemObj, TemporalConstants.CALENDAR))) {
                return itemObj;
            }
            item = this.getCalendarProperty(itemObj);
            if (this.hasCalendar2Profile.profile(isObjectNode.executeBoolean(item) && !JSObject.hasProperty((JSDynamicObject)item, TemporalConstants.CALENDAR))) {
                return (JSDynamicObject)item;
            }
        }
        if (!TemporalUtil.isBuiltinCalendar(identifier = toStringNode.executeString(item))) {
            this.parseBranch.enter();
            identifier = TemporalUtil.parseTemporalCalendarString(identifier);
            if (!TemporalUtil.isBuiltinCalendar(identifier)) {
                throw TemporalErrors.createRangeErrorCalendarUnknown();
            }
        }
        return JSTemporalCalendar.create(this.context, this.getRealm(), identifier, errorBranch);
    }

    private Object getCalendarProperty(JSDynamicObject obj) {
        if (this.getCalendarPropertyNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getCalendarPropertyNode = this.insert(PropertyGetNode.create(TemporalConstants.CALENDAR, false, this.context));
        }
        return this.getCalendarPropertyNode.getValue(obj);
    }
}

