/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.array.dyn;

import java.util.Arrays;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.JSConfig;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.array.DynamicArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.array.ScriptArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.array.dyn.AbstractJSObjectArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.array.dyn.ArrayCopy;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.array.dyn.ContiguousJSObjectArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.array.dyn.HolesJSObjectArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import kasuga.lib.vendor_modules.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public final class ZeroBasedJSObjectArray
extends AbstractJSObjectArray {
    private static final ZeroBasedJSObjectArray ZERO_BASED_JSOBJECT_ARRAY = (ZeroBasedJSObjectArray)new ZeroBasedJSObjectArray(0, ZeroBasedJSObjectArray.createCache()).maybePreinitializeCache();

    public static <T> ZeroBasedJSObjectArray makeZeroBasedJSObjectArray(JSDynamicObject object, int length, int usedLength, T[] array, int integrityLevel) {
        ZeroBasedJSObjectArray arrayType = (ZeroBasedJSObjectArray)ZeroBasedJSObjectArray.createZeroBasedJSObjectArray().setIntegrityLevel(integrityLevel);
        JSAbstractArray.arraySetLength(object, length);
        JSAbstractArray.arraySetUsedLength(object, usedLength);
        JSAbstractArray.arraySetArray(object, array);
        return arrayType;
    }

    public static ZeroBasedJSObjectArray createZeroBasedJSObjectArray() {
        return ZERO_BASED_JSOBJECT_ARRAY;
    }

    private ZeroBasedJSObjectArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    public boolean isSupported(JSDynamicObject object, long index) {
        return ZeroBasedJSObjectArray.isSupportedZeroBased(object, (int)index);
    }

    @Override
    public JSDynamicObject getInBoundsFastJSObject(JSDynamicObject object, int index) {
        return this.castNonNull(ZeroBasedJSObjectArray.getArray(object)[index]);
    }

    @Override
    public void setInBoundsFast(JSDynamicObject object, int index, JSDynamicObject value) {
        ZeroBasedJSObjectArray.getArray((JSDynamicObject)object)[index] = ZeroBasedJSObjectArray.checkNonNull(value);
    }

    @Override
    protected int prepareInBoundsFast(JSDynamicObject object, long index) {
        return (int)index;
    }

    @Override
    protected int prepareInBounds(JSDynamicObject object, int index, ScriptArray.ProfileHolder profile) {
        ZeroBasedJSObjectArray.prepareInBoundsZeroBased(object, index, profile);
        return index;
    }

    @Override
    protected int prepareSupported(JSDynamicObject object, int index, ScriptArray.ProfileHolder profile) {
        this.prepareSupportedZeroBased(object, index, profile);
        return index;
    }

    @Override
    protected void setLengthLess(JSDynamicObject object, long length, ScriptArray.ProfileHolder profile) {
        this.setLengthLessZeroBased(object, length, profile);
    }

    @Override
    public ContiguousJSObjectArray toContiguous(JSDynamicObject object, long index, Object value) {
        JSDynamicObject[] array = ZeroBasedJSObjectArray.getArray(object);
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedJSObjectArray.getUsedLength(object);
        ContiguousJSObjectArray newArray = ContiguousJSObjectArray.makeContiguousJSObjectArray(object, length, array, 0L, 0, usedLength, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedJSObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public HolesJSObjectArray toHoles(JSDynamicObject object, long index, Object value) {
        JSDynamicObject[] array = ZeroBasedJSObjectArray.getArray(object);
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedJSObjectArray.getUsedLength(object);
        HolesJSObjectArray newArray = HolesJSObjectArray.makeHolesJSObjectArray(object, length, array, 0L, 0, usedLength, 0, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedJSObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ZeroBasedObjectArray toObject(JSDynamicObject object, long index, Object value) {
        JSDynamicObject[] array = ZeroBasedJSObjectArray.getArray(object);
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedJSObjectArray.getUsedLength(object);
        Object[] doubleCopy = ArrayCopy.jsobjectToObject(array, 0, usedLength);
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, length, usedLength, doubleCopy, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedJSObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public long firstElementIndex(JSDynamicObject object) {
        return 0L;
    }

    @Override
    public long lastElementIndex(JSDynamicObject object) {
        return ZeroBasedJSObjectArray.getUsedLength(object) - 1;
    }

    @Override
    public ScriptArray removeRangeImpl(JSDynamicObject object, long start, long end) {
        Object[] array = ZeroBasedJSObjectArray.getArray(object);
        int usedLength = ZeroBasedJSObjectArray.getUsedLength(object);
        long moveLength = (long)usedLength - end;
        if (moveLength > 0L) {
            System.arraycopy(array, (int)end, array, (int)start, (int)moveLength);
        }
        if (start < (long)usedLength) {
            Arrays.fill(array, (int)(start + Math.max(0L, moveLength)), usedLength, null);
            int newUsedLength = (int)(moveLength > 0L ? (long)usedLength - (end - start) : start);
            JSAbstractArray.arraySetUsedLength(object, newUsedLength);
        }
        return this;
    }

    @Override
    public ScriptArray shiftRangeImpl(JSDynamicObject object, long from) {
        int usedLength = ZeroBasedJSObjectArray.getUsedLength(object);
        if (from < (long)usedLength) {
            Object[] array = ZeroBasedJSObjectArray.getArray(object);
            Arrays.fill(array, 0, (int)from, null);
            return ContiguousJSObjectArray.makeContiguousJSObjectArray(object, (long)this.lengthInt(object) - from, (JSDynamicObject[])array, -from, (int)from, (int)((long)usedLength - from), this.integrityLevel);
        }
        return this.removeRangeImpl(object, 0L, from);
    }

    @Override
    public ScriptArray addRangeImpl(JSDynamicObject object, long offset, int size) {
        return this.addRangeImplZeroBased(object, offset, size);
    }

    @Override
    public boolean hasHoles(JSDynamicObject object) {
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedJSObjectArray.getUsedLength(object);
        return usedLength < length;
    }

    @Override
    protected ZeroBasedJSObjectArray withIntegrityLevel(int newIntegrityLevel) {
        return new ZeroBasedJSObjectArray(newIntegrityLevel, this.cache);
    }

    @Override
    public long nextElementIndex(JSDynamicObject object, long index) {
        return this.nextElementIndexZeroBased(object, index);
    }
}

