/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.instrument;

import kasuga.lib.vendor_modules.com.oracle.truffle.tools.chromeinspector.instrument.InspectorInstrument;
import kasuga.lib.vendor_modules.org.graalvm.options.OptionValues;

public final class KeyStoreOptions {
    private static final String KEY_STORE_FILE_PATH = "javax.net.ssl.keyStore";
    private static final String KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String KEY_STORE_FILE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String KEY_STORE_KEY_RECOVER_PASSWORD = "javax.net.ssl.keyPassword";
    private final OptionValues options;

    KeyStoreOptions(OptionValues options) {
        this.options = options;
    }

    public String getKeyStore() {
        String ks = this.options.get(InspectorInstrument.KeyStore);
        if (ks.isEmpty()) {
            ks = System.getProperty(KEY_STORE_FILE_PATH);
        }
        return ks;
    }

    public String getKeyStoreType() {
        String kst = this.options.get(InspectorInstrument.KeyStoreType);
        if (kst.isEmpty()) {
            kst = System.getProperty(KEY_STORE_TYPE);
        }
        return kst;
    }

    public String getKeyStorePassword() {
        String ksp = this.options.get(InspectorInstrument.KeyStorePassword);
        if (ksp.isEmpty()) {
            ksp = System.getProperty(KEY_STORE_FILE_PASSWORD);
        }
        return ksp;
    }

    public String getKeyPassword() {
        String kp = this.options.get(InspectorInstrument.KeyPassword);
        if (kp.isEmpty()) {
            kp = System.getProperty(KEY_STORE_KEY_RECOVER_PASSWORD);
        }
        return kp;
    }
}

