/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.enums;

import com.caoccao.javet.interfaces.IJavaFunction;
import com.caoccao.javet.interfaces.IJavaSupplier;
import com.caoccao.javet.interop.options.NodeRuntimeOptions;
import com.caoccao.javet.interop.options.RuntimeOptions;
import com.caoccao.javet.interop.options.V8RuntimeOptions;
import java.util.Objects;

public enum JSRuntimeType {
    Node("node", false, "12.4.254.21-node.19", NodeRuntimeOptions::new, o -> o instanceof NodeRuntimeOptions),
    NodeI18n("node", true, "12.4.254.21-node.19", NodeRuntimeOptions::new, o -> o instanceof NodeRuntimeOptions),
    V8("v8", false, "13.0.245.16", V8RuntimeOptions::new, o -> o instanceof V8RuntimeOptions),
    V8I18n("v8", true, "13.0.245.16", V8RuntimeOptions::new, o -> o instanceof V8RuntimeOptions);

    private final boolean i18nEnabled;
    private final String name;
    private final IJavaSupplier<? extends RuntimeOptions<?>> runtimeOptionsConstructor;
    private final IJavaFunction<RuntimeOptions<?>, Boolean> runtimeOptionsValidator;
    private final String version;

    private JSRuntimeType(String name, boolean i18nEnabled, String version, IJavaSupplier<RuntimeOptions<?>> runtimeOptionsConstructor, IJavaFunction<RuntimeOptions<?>, Boolean> runtimeOptionsValidator) {
        this.runtimeOptionsConstructor = Objects.requireNonNull(runtimeOptionsConstructor);
        this.runtimeOptionsValidator = Objects.requireNonNull(runtimeOptionsValidator);
        this.name = name;
        this.i18nEnabled = i18nEnabled;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public <Options extends RuntimeOptions<?>> Options getRuntimeOptions() {
        return (Options)this.runtimeOptionsConstructor.get();
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isI18nEnabled() {
        return this.i18nEnabled;
    }

    public boolean isNode() {
        return this == Node || this == NodeI18n;
    }

    public boolean isRuntimeOptionsValid(RuntimeOptions<?> runtimeOptions) {
        return this.runtimeOptionsValidator.apply(runtimeOptions);
    }

    public boolean isV8() {
        return this == V8 || this == V8I18n;
    }

    public String toString() {
        return this.name + " v" + this.version;
    }
}

