/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.engine.observers;

import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.engine.observers.IV8RuntimeObserver;
import java.util.ArrayList;
import java.util.List;

public class V8RuntimeObserverAverageReferenceCount
implements IV8RuntimeObserver<Integer> {
    protected final List<Integer> referenceCountList;

    public V8RuntimeObserverAverageReferenceCount() {
        this(256);
    }

    public V8RuntimeObserverAverageReferenceCount(int capacity) {
        this.referenceCountList = new ArrayList<Integer>(capacity);
    }

    @Override
    public Integer getResult() {
        int averageReferenceCount = 0;
        if (!this.referenceCountList.isEmpty()) {
            int totalReferenceCount = 0;
            for (int referenceCount : this.referenceCountList) {
                totalReferenceCount += referenceCount;
            }
            int v8RuntimeCount = this.referenceCountList.size();
            averageReferenceCount = totalReferenceCount / v8RuntimeCount;
        }
        return averageReferenceCount;
    }

    @Override
    public void observe(V8Runtime v8Runtime) {
        this.referenceCountList.add(v8Runtime.getReferenceCount());
    }

    @Override
    public void reset() {
        this.referenceCountList.clear();
    }
}

