/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JavetReflectionUtils {
    private static final String METHOD_NAME_WRITE_REPLACE = "writeReplace";

    private JavetReflectionUtils() {
    }

    public static String getMethodNameFromLambda(Serializable lambda) {
        Objects.requireNonNull(lambda);
        try {
            Method method = lambda.getClass().getDeclaredMethod(METHOD_NAME_WRITE_REPLACE, new Class[0]);
            method.setAccessible(true);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke((Object)lambda, new Object[0]);
            return serializedLambda.getImplMethodName();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Set<String> getMethodNameSetFromLambdas(Serializable ... lambdas) {
        return Stream.of((Object[])Objects.requireNonNull(lambdas)).filter(Objects::nonNull).map(JavetReflectionUtils::getMethodNameFromLambda).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static void safeSetAccessible(AccessibleObject accessibleObject) {
        try {
            accessibleObject.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

