/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference.builtin;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetSupplier;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import java.util.HashMap;
import java.util.Map;

public class V8ValueBuiltInSymbol
extends V8ValueFunction {
    public static final String NAME = "Symbol";
    public static final String PROPERTY_ASYNC_ITERATOR = "asyncIterator";
    public static final String PROPERTY_HAS_INSTANCE = "hasInstance";
    public static final String PROPERTY_IS_CONCAT_SPREADABLE = "isConcatSpreadable";
    public static final String PROPERTY_ITERATOR = "iterator";
    public static final String PROPERTY_MATCH = "match";
    public static final String PROPERTY_MATCH_ALL = "matchAll";
    public static final String PROPERTY_REPLACE = "replace";
    public static final String PROPERTY_SEARCH = "search";
    public static final String PROPERTY_SPECIES = "species";
    public static final String PROPERTY_SPLIT = "split";
    public static final String PROPERTY_TO_PRIMITIVE = "toPrimitive";
    public static final String PROPERTY_TO_STRING_TAG = "toStringTag";
    public static final String PROPERTY_UNSCOPABLES = "unscopables";
    public static final String SYMBOL_PROPERTY_ASYNC_ITERATOR = "Symbol.asyncIterator";
    public static final String SYMBOL_PROPERTY_HAS_INSTANCE = "Symbol.hasInstance";
    public static final String SYMBOL_PROPERTY_IS_CONCAT_SPREADABLE = "Symbol.isConcatSpreadable";
    public static final String SYMBOL_PROPERTY_ITERATOR = "Symbol.iterator";
    public static final String SYMBOL_PROPERTY_MATCH = "Symbol.match";
    public static final String SYMBOL_PROPERTY_MATCH_ALL = "Symbol.matchAll";
    public static final String SYMBOL_PROPERTY_REPLACE = "Symbol.replace";
    public static final String SYMBOL_PROPERTY_SEARCH = "Symbol.search";
    public static final String SYMBOL_PROPERTY_SPECIES = "Symbol.species";
    public static final String SYMBOL_PROPERTY_SPLIT = "Symbol.split";
    public static final String SYMBOL_PROPERTY_TO_PRIMITIVE = "Symbol.toPrimitive";
    public static final String SYMBOL_PROPERTY_TO_STRING_TAG = "Symbol.toStringTag";
    public static final String SYMBOL_PROPERTY_UNSCOPABLES = "Symbol.unscopables";
    protected static final String FUNCTION_FOR = "for";
    protected static final String FUNCTION_KEY_FOR = "keyFor";
    protected Map<String, IJavetSupplier<V8ValueSymbol, Throwable>> builtInSymbolMap = new HashMap<String, IJavetSupplier<V8ValueSymbol, Throwable>>();

    public V8ValueBuiltInSymbol(V8Runtime v8Runtime, long handle) throws JavetException {
        super(v8Runtime, handle);
        this.builtInSymbolMap.put(PROPERTY_ASYNC_ITERATOR, this::getAsyncIterator);
        this.builtInSymbolMap.put(PROPERTY_HAS_INSTANCE, this::getHasInstance);
        this.builtInSymbolMap.put(PROPERTY_IS_CONCAT_SPREADABLE, this::getIsConcatSpreadable);
        this.builtInSymbolMap.put(PROPERTY_ITERATOR, this::getIterator);
        this.builtInSymbolMap.put(PROPERTY_MATCH, this::getMatch);
        this.builtInSymbolMap.put(PROPERTY_MATCH_ALL, this::getMatchAll);
        this.builtInSymbolMap.put(PROPERTY_REPLACE, this::getReplace);
        this.builtInSymbolMap.put(PROPERTY_SEARCH, this::getSearch);
        this.builtInSymbolMap.put(PROPERTY_SPECIES, this::getSpecies);
        this.builtInSymbolMap.put(PROPERTY_SPLIT, this::getSplit);
        this.builtInSymbolMap.put(PROPERTY_TO_PRIMITIVE, this::getToPrimitive);
        this.builtInSymbolMap.put(PROPERTY_TO_STRING_TAG, this::getToStringTag);
        this.builtInSymbolMap.put(PROPERTY_UNSCOPABLES, this::getUnscopables);
    }

    public V8ValueSymbol _for(String description) throws JavetException {
        return (V8ValueSymbol)this.invoke(FUNCTION_FOR, description);
    }

    public V8ValueSymbol getAsyncIterator() throws JavetException {
        return (V8ValueSymbol)this.get(PROPERTY_ASYNC_ITERATOR);
    }

    public V8ValueSymbol getBuiltInSymbol(String description) throws JavetException {
        IJavetSupplier<V8ValueSymbol, Throwable> iJavetSupplier = this.builtInSymbolMap.get(description);
        if (iJavetSupplier != null) {
            try {
                return iJavetSupplier.get();
            }
            catch (JavetException e) {
                throw e;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public V8ValueSymbol getHasInstance() throws JavetException {
        return (V8ValueSymbol)this.get(PROPERTY_HAS_INSTANCE);
    }

    public V8ValueSymbol getIsConcatSpreadable() throws JavetException {
        return (V8ValueSymbol)this.get(PROPERTY_IS_CONCAT_SPREADABLE);
    }

    public V8ValueSymbol getIterator() throws JavetException {
        return (V8ValueSymbol)this.get(PROPERTY_ITERATOR);
    }

    public V8ValueSymbol getMatch() throws JavetException {
        return (V8ValueSymbol)this.get(PROPERTY_MATCH);
    }

    public V8ValueSymbol getMatchAll() throws JavetException {
        return (V8ValueSymbol)this.get(PROPERTY_MATCH_ALL);
    }

    public V8ValueSymbol getReplace() throws JavetException {
        return (V8ValueSymbol)this.get(PROPERTY_REPLACE);
    }

    public V8ValueSymbol getSearch() throws JavetException {
        return (V8ValueSymbol)this.get(PROPERTY_SEARCH);
    }

    public V8ValueSymbol getSpecies() throws JavetException {
        return (V8ValueSymbol)this.get(PROPERTY_SPECIES);
    }

    public V8ValueSymbol getSplit() throws JavetException {
        return (V8ValueSymbol)this.get(PROPERTY_SPLIT);
    }

    public V8ValueSymbol getToPrimitive() throws JavetException {
        return (V8ValueSymbol)this.get(PROPERTY_TO_PRIMITIVE);
    }

    public V8ValueSymbol getToStringTag() throws JavetException {
        return (V8ValueSymbol)this.get(PROPERTY_TO_STRING_TAG);
    }

    public V8ValueSymbol getUnscopables() throws JavetException {
        return (V8ValueSymbol)this.get(PROPERTY_UNSCOPABLES);
    }

    public String keyFor(V8ValueSymbol v8ValueSymbol) throws JavetException {
        return this.invokeString(FUNCTION_KEY_FOR, v8ValueSymbol);
    }

    public V8ValueBuiltInSymbol toClone() throws JavetException {
        return this;
    }
}

