/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.base;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import java.util.function.Supplier;
import kasuga.lib.KasugaLib;
import kasuga.lib.core.base.CustomBlockRenderer;
import kasuga.lib.registrations.create.TrackMaterialReg;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CustomTrackRenderer<T extends TrackBlock>
extends CustomBlockRenderer<T> {
    public TrackMaterial material = null;
    public TrackMaterialReg.TrackOffsetIdentifier offset = null;
    public static final Vec3 ONE = new Vec3(1.0, 0.0, 0.0);
    public static final Vec3 NEG_ONE = new Vec3(-1.0, 0.0, 0.0);

    public CustomTrackRenderer(Supplier<T> blockSupplier) {
        super(blockSupplier);
    }

    @Override
    public synchronized void render(BlockState state, BlockPos pos, BlockAndTintGetter level, PoseStack stack, VertexConsumer consumer, RenderType type, int light) {
        if (this.isBusy()) {
            return;
        }
        this.setBusy(true);
        if (this.material == null) {
            this.material = ((TrackBlock)this.getBlock()).getMaterial();
            this.offset = KasugaLib.STACKS.getCachedTrackMaterial(this.material).trackOffsets();
        }
        PartialModel left = this.material.getModelHolder().segment_left();
        PartialModel right = this.material.getModelHolder().segment_right();
        PartialModel tie = this.material.getModelHolder().tie();
        SuperByteBuffer leftBuffer = CachedBufferer.partial((PartialModel)left, (BlockState)state);
        SuperByteBuffer rightBuffer = CachedBufferer.partial((PartialModel)right, (BlockState)state);
        SuperByteBuffer tieBuffer = CachedBufferer.partial((PartialModel)tie, (BlockState)state);
        TrackShape shape = (TrackShape)state.m_61143_((Property)TrackBlock.SHAPE);
        Direction direction = this.getFacingMapping(shape);
        if (direction == Direction.DOWN) {
            this.setBusy(false);
            return;
        }
        float f = -direction.m_122424_().m_122435_();
        stack.m_85837_(0.5, 0.06, 0.5);
        stack.m_85845_(Vector3f.f_122225_.m_122240_(f));
        stack.m_85837_(-0.5, 0.0, -0.5);
        if (this.isAscending(shape)) {
            this.renderAscendingSegment(stack, consumer, leftBuffer, rightBuffer, tieBuffer);
        } else {
            this.renderSimpleSegment(stack, consumer, leftBuffer, rightBuffer, tieBuffer);
        }
        this.setBusy(false);
    }

    private void renderSimpleSegment(PoseStack stack, VertexConsumer consumer, SuperByteBuffer left, SuperByteBuffer right, SuperByteBuffer tie) {
        this.renderTrackSegment(stack, consumer, left, right, tie, this.offset);
        stack.m_85837_(0.0, 0.0, 0.5);
        this.renderTrackSegment(stack, consumer, left, right, tie, this.offset);
    }

    private void renderAscendingSegment(PoseStack stack, VertexConsumer consumer, SuperByteBuffer left, SuperByteBuffer right, SuperByteBuffer tie) {
        stack.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
        stack.m_85837_(0.0, 0.625, -0.9);
        this.renderTrackSegment(stack, consumer, left, right, tie, this.offset);
        stack.m_85837_(0.0, 0.0, 0.5);
        this.renderTrackSegment(stack, consumer, left, right, tie, this.offset);
        stack.m_85837_(0.0, 0.0, 0.5);
        this.renderTrackSegment(stack, consumer, left, right, tie, this.offset);
    }

    private void renderTrackSegment(PoseStack stack, VertexConsumer consumer, SuperByteBuffer left, SuperByteBuffer right, SuperByteBuffer tie, TrackMaterialReg.TrackOffsetIdentifier identifier) {
        if (stack.m_85851_()) {
            stack.m_85836_();
        }
        left.translate(identifier.apply(ONE).m_82520_(0.5, 0.0, 0.0));
        right.translate(identifier.apply(NEG_ONE).m_82520_(0.5, 0.0, 0.0));
        left.renderInto(stack, consumer);
        right.renderInto(stack, consumer);
        tie.renderInto(stack, consumer);
    }

    private Direction getFacingMapping(TrackShape shape) {
        return switch (shape) {
            case TrackShape.AS, TrackShape.TS -> Direction.SOUTH;
            case TrackShape.AE, TrackShape.XO, TrackShape.TE -> Direction.EAST;
            case TrackShape.AN, TrackShape.ZO, TrackShape.TN -> Direction.NORTH;
            case TrackShape.AW, TrackShape.TW -> Direction.WEST;
            default -> Direction.DOWN;
        };
    }

    private boolean isAscending(TrackShape shape) {
        return switch (shape) {
            case TrackShape.AS, TrackShape.AE, TrackShape.AN, TrackShape.AW -> true;
            default -> false;
        };
    }
}

