/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.base;

import java.io.File;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import kasuga.lib.core.annos.Inner;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class Saved<T extends SavedData> {
    public final String resourceKey;
    @Nonnull
    Supplier<T> dataSupplier;
    @Nonnull
    LoadFunction<T> loadFunction;
    T data;

    public Saved(String resourceKey, @NotNull Supplier<T> data, @NotNull LoadFunction<T> loadFunction) {
        this.resourceKey = resourceKey;
        this.dataSupplier = data;
        this.loadFunction = loadFunction;
    }

    public T loadFromDisk(ServerLevel level) {
        this.data = level.m_8895_().m_164861_(this::load, this.dataSupplier, this.resourceKey);
        return this.data;
    }

    public void saveToDisk(ServerLevel level) {
        if (this.data == null) {
            return;
        }
        this.data.m_77760_(true);
        level.m_8895_().m_164855_(this.resourceKey, this.data);
    }

    @Inner
    public T load(CompoundTag nbt) {
        return this.loadFunction.load(nbt);
    }

    public Optional<T> getData() {
        return Optional.of(this.data);
    }

    public void save(CompoundTag tag) {
        this.data.m_7176_(tag);
    }

    public void saveToFile(File file) {
        this.data.m_77757_(file);
    }

    public static interface LoadFunction<T extends SavedData> {
        public T load(CompoundTag var1);
    }
}

