/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.data.anchor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import kasuga.lib.core.client.animation.data.Animation;
import kasuga.lib.core.client.animation.infrastructure.AnimAssignable;
import kasuga.lib.core.client.animation.infrastructure.AnimationElement;
import kasuga.lib.core.client.animation.infrastructure.IAnchor;
import kasuga.lib.core.client.render.PoseContext;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import kasuga.lib.vendor_modules.interpreter.compute.data.functions.Function;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;

public class Anchor
extends AnimationElement
implements AnimAssignable,
IAnchor {
    private final Namespace namespace;
    private IAnchor.AnchorInvoker invoker = null;
    private IAnchor.AnchorContext anchorContext = ZERO;
    private final Animation animation;
    private IAnchor parent = null;
    private final ArrayList<Pair<Formula, PoseContext.ActionType>> actions;

    public Anchor(Animation animation, Namespace namespace, String key) {
        super(key);
        this.namespace = namespace;
        this.animation = animation;
        this.actions = new ArrayList();
        this.updateVars();
    }

    public static Anchor decode(String key, Namespace namespace, Animation animation, JsonObject json) {
        Anchor result = new Anchor(animation, namespace, key);
        if (json.has("parent")) {
            result.invoker = () -> result.setParent(json.get("parent").getAsString());
        }
        if (json.has("action")) {
            JsonArray actions = json.getAsJsonArray("action");
            for (JsonElement str : actions) {
                result.decodeFormula(str.getAsString());
            }
        }
        result.init();
        return result;
    }

    public void invoke() {
        if (this.invoker == null) {
            return;
        }
        this.invoker.invoke();
    }

    public void setParent(String parentCodec) {
        if (this.animation.containsBoneMovement(parentCodec)) {
            this.parent = this.animation.getBonesGroup().getMovement(parentCodec);
        } else if (this.animation.containsAnchor(parentCodec)) {
            this.parent = this.animation.getAnchors().getAnchor(parentCodec);
        }
    }

    public void decodeFormula(String code) {
        Formula formula = this.namespace.decodeFormula(code);
        if (formula instanceof Function) {
            Function f = (Function)formula;
            String codec = f.getCodec();
            if (f.paramCount() >= 1) {
                switch (codec) {
                    case "translate": {
                        this.actions.add(Pair.of(f, PoseContext.ActionType.TRANSLATE));
                        break;
                    }
                    case "x_rot": 
                    case "x_rot_rad": {
                        this.actions.add(Pair.of(f, PoseContext.ActionType.X_ROT));
                        break;
                    }
                    case "y_rot": 
                    case "y_rot_rad": {
                        this.actions.add(Pair.of(f, PoseContext.ActionType.Y_ROT));
                        break;
                    }
                    case "z_rot": 
                    case "z_rot_rad": {
                        this.actions.add(Pair.of(f, PoseContext.ActionType.Z_ROT));
                        break;
                    }
                    case "scale": {
                        this.actions.add(Pair.of(f, PoseContext.ActionType.SCALE));
                    }
                }
            }
        }
    }

    public void clearFormula() {
        this.actions.clear();
    }

    public void removeFormula(int index) {
        this.actions.remove(index);
    }

    public float getX() {
        return this.anchorContext.x();
    }

    public float getY() {
        return this.anchorContext.y();
    }

    public float getZ() {
        return this.anchorContext.z();
    }

    public float getXRot() {
        return this.anchorContext.x_rot();
    }

    public float getYRot() {
        return this.anchorContext.y_rot();
    }

    public float getZRot() {
        return this.anchorContext.z_rot();
    }

    public float getXScale() {
        return this.anchorContext.x_scale();
    }

    public float getYScale() {
        return this.anchorContext.y_scale();
    }

    public float getZScale() {
        return this.anchorContext.z_scale();
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isAssignable() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void assign(String codec, float value) {
        this.namespace.assign(codec, value);
    }

    @Override
    public void init() {
        this.updateVars();
    }

    @Override
    public void updateVars() {
        this.namespace.assign(this.key() + ".x", this.getX());
        this.namespace.assign(this.key() + ".y", this.getY());
        this.namespace.assign(this.key() + ".z", this.getZ());
        this.namespace.assign(this.key() + ".x_rot", this.getXRot());
        this.namespace.assign(this.key() + ".y_rot", this.getYRot());
        this.namespace.assign(this.key() + ".z_rot", this.getZRot());
        this.namespace.assign(this.key() + ".x_scale", this.getXScale());
        this.namespace.assign(this.key() + ".y_scale", this.getYScale());
        this.namespace.assign(this.key() + ".z_scale", this.getZScale());
    }

    @Override
    public IAnchor.AnchorContext getMovement() {
        return this.innerMove();
    }

    @Override
    public ArrayList<Pair<Formula, PoseContext.ActionType>> getMoves() {
        return this.actions;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public IAnchor getParent() {
        return this.parent;
    }
}

