/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.data.anchor;

import com.google.gson.JsonObject;
import java.util.HashMap;
import kasuga.lib.core.client.animation.data.Animation;
import kasuga.lib.core.client.animation.data.anchor.Anchor;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;

public class AnchorsGroup {
    private final HashMap<String, Anchor> anchors = new HashMap();
    private final Namespace namespace;
    private final Animation animation;

    public AnchorsGroup(Animation animation, Namespace namespace) {
        this.namespace = namespace;
        this.animation = animation;
    }

    public boolean containsAnchor(String name) {
        return this.anchors.containsKey(name);
    }

    public Anchor getAnchor(String name) {
        return this.anchors.getOrDefault(name, null);
    }

    public void addAnchor(Anchor anchor) {
        this.anchors.put(anchor.key(), anchor);
    }

    public void removeAnchor(String name) {
        this.anchors.remove(name);
    }

    public void decodeAnchors(JsonObject jsonObject) {
        for (String key : jsonObject.keySet()) {
            JsonObject object = jsonObject.getAsJsonObject(key);
            this.anchors.put(key, Anchor.decode(key, this.namespace, this.animation, object));
        }
    }

    public void init() {
        this.anchors.values().forEach(Anchor::invoke);
    }
}

