/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.data.timer;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kasuga.lib.core.client.animation.data.timer.TimeLine;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class TimeLineGroup {
    private final HashMap<String, TimeLine> timeLines;
    private final Namespace namespace;

    public TimeLineGroup(Namespace namespace) {
        this.namespace = namespace;
        this.timeLines = new HashMap();
    }

    public void decode(JsonObject object) {
        Set entries = object.entrySet();
        for (Map.Entry entry : entries) {
            Object v = entry.getValue();
            if (!(v instanceof JsonObject)) continue;
            JsonObject jsonObject = (JsonObject)v;
            this.timeLines.put((String)entry.getKey(), TimeLine.decode((String)entry.getKey(), this.namespace, jsonObject));
        }
    }

    @Nullable
    public TimeLine getTimeLine(String key) {
        return this.timeLines.getOrDefault(key, null);
    }

    public boolean containsTimeLine(String key) {
        return this.timeLines.containsKey(key);
    }

    public void action() {
        this.timeLines.values().forEach(TimeLine::action);
    }

    public void tick() {
        this.timeLines.values().forEach(TimeLine::actionTicking);
    }

    public void init() {
        this.timeLines.values().forEach(TimeLine::init);
    }

    public void addTimeLine(TimeLine timeLine) {
        this.timeLines.put(timeLine.key(), timeLine);
    }

    public Namespace getNamespace() {
        return this.namespace;
    }
}

