/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.data.trigger;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kasuga.lib.core.client.animation.data.trigger.Trigger;
import kasuga.lib.vendor_modules.interpreter.compute.data.Namespace;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TriggerGroup {
    private final HashMap<String, Trigger> triggers;
    private final Namespace namespace;

    public TriggerGroup(Namespace namespace) {
        this.namespace = namespace;
        this.triggers = new HashMap();
    }

    public void decode(JsonObject object) {
        Set entries = object.entrySet();
        for (Map.Entry entry : entries) {
            Object v = entry.getValue();
            if (!(v instanceof JsonObject)) continue;
            JsonObject jsonObject = (JsonObject)v;
            this.triggers.put((String)entry.getKey(), Trigger.decode((String)entry.getKey(), this.namespace, jsonObject));
        }
    }

    public void init() {
        this.triggers.values().forEach(Trigger::init);
    }

    public void action() {
        for (Trigger trigger : this.triggers.values()) {
            trigger.action();
        }
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public HashMap<String, Trigger> getTriggers() {
        return this.triggers;
    }
}

