/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.infrastructure;

import java.util.ArrayList;
import kasuga.lib.core.client.animation.data.Animation;
import kasuga.lib.core.client.animation.data.bones.BoneMovement;
import kasuga.lib.core.client.render.PoseContext;
import kasuga.lib.core.util.data_type.Pair;
import kasuga.lib.vendor_modules.interpreter.compute.data.functions.Function;
import kasuga.lib.vendor_modules.interpreter.compute.infrastructure.Formula;

public interface IAnchor {
    public static final AnchorContext ZERO = new AnchorContext(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);

    public AnchorContext getMovement();

    public ArrayList<Pair<Formula, PoseContext.ActionType>> getMoves();

    public Animation getAnimation();

    public IAnchor getParent();

    public void updateVars();

    default public AnchorContext innerMove() {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float x_rot = 0.0f;
        float y_rot = 0.0f;
        float z_rot = 0.0f;
        float x_scale = 0.0f;
        float y_scale = 0.0f;
        float z_scale = 0.0f;
        if (this.getParent() != null) {
            AnchorContext context = this.getParent().getMovement();
            x = context.x();
            y = context.y();
            z = context.z();
            x_rot = context.x_rot();
            y_rot = context.y_rot();
            z_rot = context.z_rot();
            x_scale = context.x_scale();
            y_scale = context.y_scale();
            z_scale = context.z_scale();
        }
        for (Pair<Formula, PoseContext.ActionType> movements : this.getMoves()) {
            Function function = (Function)movements.getFirst();
            switch (movements.getSecond()) {
                case SCALE: {
                    if (function.params.size() == 1) {
                        IAnchor anchor = this.getAnimation().getAsAnchor(function.params.get(0).toString());
                        AnchorContext context = anchor.getMovement();
                        x_scale *= context.x_scale;
                        y_scale *= context.y_scale;
                        z_scale *= context.z_scale;
                        break;
                    }
                    x_scale *= function.params.get(0).getResult();
                    y_scale *= function.params.get(1).getResult();
                    z_scale *= function.params.get(2).getResult();
                    break;
                }
                case X_ROT: {
                    x_rot = (float)((double)x_rot + (function.getCodec().endsWith("rad") ? Math.toDegrees(function.params.get(0).getResult()) : (double)function.params.get(0).getResult()));
                    break;
                }
                case Y_ROT: {
                    y_rot = (float)((double)y_rot + (function.getCodec().endsWith("rad") ? Math.toDegrees(function.params.get(0).getResult()) : (double)function.params.get(0).getResult()));
                    break;
                }
                case Z_ROT: {
                    z_rot = (float)((double)z_rot + (function.getCodec().endsWith("rad") ? Math.toDegrees(function.params.get(0).getResult()) : (double)function.params.get(0).getResult()));
                    break;
                }
                case TRANSLATE: {
                    float pz;
                    float py;
                    float px;
                    if (function.params.size() == 1) {
                        IAnchor anchor = this.getAnimation().getAsAnchor(function.params.get(0).toString());
                        AnchorContext context = anchor.getMovement();
                        px = context.x * x_scale;
                        py = context.y * y_scale;
                        pz = context.z * z_scale;
                    } else {
                        px = function.params.get(0).getResult() * x_scale;
                        py = function.params.get(1).getResult() * y_scale;
                        pz = function.params.get(2).getResult() * z_scale;
                    }
                    x += px * BoneMovement.cos(y_rot) * BoneMovement.cos(z_rot) + py * (BoneMovement.sin(x_rot) * BoneMovement.sin(y_rot) * BoneMovement.cos(z_rot) - BoneMovement.cos(x_rot) * BoneMovement.sin(z_rot)) + pz * (BoneMovement.sin(y_rot) * BoneMovement.cos(x_rot) * BoneMovement.cos(z_rot) + BoneMovement.sin(x_rot) * BoneMovement.sin(z_rot));
                    y += px * BoneMovement.cos(y_rot) * BoneMovement.sin(z_rot) + py * (BoneMovement.sin(x_rot) * BoneMovement.sin(y_rot) * BoneMovement.sin(z_rot) + BoneMovement.cos(x_rot) * BoneMovement.cos(z_rot)) + pz * (BoneMovement.sin(y_rot) * BoneMovement.sin(z_rot) * BoneMovement.cos(x_rot) - BoneMovement.sin(x_rot) * BoneMovement.cos(z_rot));
                    z += px * -BoneMovement.sin(y_rot) + py * BoneMovement.sin(x_rot) * BoneMovement.cos(y_rot) + pz * BoneMovement.cos(x_rot) * BoneMovement.cos(y_rot);
                }
            }
        }
        return new AnchorContext(x, y, z, x_rot, y_rot, z_rot, x_scale, y_scale, z_scale);
    }

    public record AnchorContext(float x, float y, float z, float x_rot, float y_rot, float z_rot, float x_scale, float y_scale, float z_scale) {
    }

    public static interface AnchorInvoker {
        public void invoke();
    }
}

