/*
 * Decompiled with CFR 0.152.
 */
package kasuga.lib.core.client.animation.neo_neo.key_frame;

import java.util.HashMap;
import java.util.Set;
import kasuga.lib.core.client.animation.neo_neo.base.Movement;
import kasuga.lib.core.client.animation.neo_neo.key_frame.KeyFrame;
import kasuga.lib.core.util.data_type.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class KeyFrameHolder<T extends Movement> {
    private final HashMap<ResourceLocation, KeyFrame<? extends T>> holder = new HashMap();

    public KeyFrameHolder() {
    }

    public KeyFrameHolder(Pair<ResourceLocation, KeyFrame<? extends T>> ... frames) {
        this();
        for (Pair<ResourceLocation, KeyFrame<T>> pair : frames) {
            this.holder.put(pair.getFirst(), pair.getSecond());
        }
    }

    public void add(ResourceLocation location, KeyFrame<? extends T> frame) {
        this.holder.put(location, frame);
    }

    public KeyFrame<? extends T> get(ResourceLocation location) {
        return this.holder.getOrDefault(location, null);
    }

    public KeyFrame<? extends T> createInstance(Float time, ResourceLocation location) {
        return this.createInstance(time, Vec3.f_82478_, location);
    }

    public KeyFrame<? extends T> createInstance(Float time, Vec3 data, ResourceLocation location) {
        Object result = this.get(location).clone();
        ((KeyFrame)result).setTime(time.floatValue());
        ((KeyFrame)result).setData(data);
        return result;
    }

    public KeyFrame<? extends T> copyFrom(KeyFrame<? extends T> org, Vec3 newData, float newTime) {
        Object neo = org.clone();
        ((KeyFrame)neo).setData(newData);
        ((KeyFrame)neo).setTime(newTime);
        return neo;
    }

    public Set<ResourceLocation> getKeys() {
        return this.holder.keySet();
    }

    public HashMap<ResourceLocation, KeyFrame<? extends T>> getHolder() {
        return this.holder;
    }

    public boolean contains(ResourceLocation resourceLocation) {
        return this.holder.containsKey(resourceLocation);
    }

    public boolean remove(ResourceLocation location) {
        if (!this.holder.containsKey(location)) {
            return false;
        }
        this.holder.remove(location);
        return true;
    }

    public int size() {
        return this.holder.size();
    }

    public boolean isEmpty() {
        return this.holder.isEmpty();
    }
}

